﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;
    using Opal.Security.Cryptography;

    /// <summary>
    /// 強制的にインクルードしたシェーダーソース定義のエンティティクラスです。
    /// </summary>
    public class ForceInclude : Entity<force_includeType>
    {
        private int index = 0;
        private int srcIndex = 0;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ForceInclude()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public ForceInclude(force_includeType data)
            : this()
        {
            this.index = data.index;
            this.srcIndex = data.src_index;
        }

        /// <summary>
        /// インデックスを取得設定します。
        /// </summary>
        public int Index
        {
            get
            {
                return this.index;
            }

            set
            {
                this.SetProperty(ref this.index, value);
            }
        }

        /// <summary>
        /// ShaderSrc のインデックスを取得設定します。
        /// </summary>
        public int SrcIndex
        {
            get
            {
                return this.srcIndex;
            }

            set
            {
                this.SetProperty(ref this.srcIndex, value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new ForceInclude();
            instance.index = this.index;
            instance.srcIndex = this.srcIndex;

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override force_includeType CreateWriteData()
        {
            var instance = new force_includeType();
            instance.index = this.index;
            instance.src_index = this.srcIndex;

            return instance;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            // Index プロパティは、出力時に計算しなおすので、CRCの計算対象外
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.srcIndex)));

            var hashValue = crc.ComputeHashUInt32(buffers.ToArray());
            return hashValue;
        }
    }
}
