﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;

    /// <summary>
    /// 中間ファイル情報のエンティティクラスです。
    /// </summary>
    public class FileInfo : ObservableEntity<file_infoType>
    {
        private Create create = null;
        private Modify modify = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public FileInfo()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public FileInfo(file_infoType data)
        {
            if (data == null)
            {
                return;
            }

            if (data.create != null)
            {
                this.create = new Create(data.create);
            }

            if (data.modify != null)
            {
                this.modify = new Modify(data.modify);
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new FileInfo();

            if (this.create != null)
            {
                instance.create = this.create.Clone() as Create;
            }

            if (this.modify != null)
            {
                instance.modify = this.modify.Clone() as Modify;
            }

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override file_infoType CreateWriteData()
        {
            if (this.create == null)
            {
                return null;
            }

            var instance = new file_infoType();

            if (this.create != null)
            {
                instance.create = this.create.CreateWriteData();
            }

            if (this.modify != null)
            {
                instance.modify = this.modify.CreateWriteData();
            }

            return instance;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            return 0;
        }
    }
}
