﻿namespace G3dCore.Converters
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading;
    using System.Threading.Tasks;
    using G3dCore.Entities;
    using G3dCore.Utilities;
    using G3dCore.Windows.Utilities;

    /// <summary>
    /// シェーダコンバータを実行するクラスです。
    /// </summary>
    public class ShaderConvertExecutor
    {
        private Thread thread = null;

        /// <summary>
        /// 指定したシェーダ設定でシェーダコンバートができるか実行します。
        /// </summary>
        /// <param name="shaderConfigFile">コンバートするシェーダ設定ファイルです。</param>
        /// <param name="shaderConfigDir">シェーダ設定ファイルのあるディレクトリです。</param>
        /// <param name="resultDelegate">結果を返すデリゲートです。</param>
        public void BeginTryShaderConvert(
            G3dFile shaderConfigFile,
            string shaderConfigDir,
            Action<bool, ShaderConverterResult> resultDelegate)
        {
            this.Cancel();

            this.thread = new Thread(new ThreadStart(
                () => ThreadUtility.BeginInvokeOnUIThread(() =>
                {
                    ShaderConverterResult result;
                    bool isSuccessful = ShaderConverterUtility.TryShaderConvert(shaderConfigFile, shaderConfigDir, out result);

                    if (resultDelegate != null)
                    {
                        resultDelegate.Invoke(isSuccessful, result);
                    }
                })
            ));

            this.thread.IsBackground = true;
            this.thread.Start();
        }

        /// <summary>
        /// 実行中コンバートをキャンセルします。
        /// </summary>
        public void Cancel()
        {
            if (this.thread != null)
            {
                if (this.thread.IsAlive)
                {
                    this.thread.Abort();
                    this.thread.Join();
                }

                this.thread = null;
            }
        }
    }
}
