﻿namespace G3dCore.Configurations.UserComfigs
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Xml.Serialization;
    using Opal.ComponentModel;

    /// <summary>
    /// 共通のユーザ設定のサブコンフィグです。
    /// </summary>
    [Serializable]
    public class CommonConfig : SubConfig
    {
        private XmlTextEditor textEditor = new XmlTextEditor();

        /// <summary>
        /// 使用するテキストエディタプログラムを取得設定します。
        /// </summary>
        public XmlTextEditor TextEditor
        {
            get
            {
                return this.textEditor;
            }

            set
            {
                this.SetProperty(ref this.textEditor, value);
            }
        }

        /// <summary>
        /// 使用するテキストエディタに関するコンフィグです。
        /// </summary>
        [XmlType("TextEditor")]
        public class XmlTextEditor : ObservableObject
        {
            private string path = string.Empty;
            private string option = string.Empty;

            /// <summary>
            /// テキストエディタのパスを取得設定します。
            /// </summary>
            [XmlAttribute]
            public string Path
            {
                get
                {
                    return this.path;
                }

                set
                {
                    this.SetProperty(ref this.path, value);
                }
            }

            /// <summary>
            /// テキストエディタ起動時に渡すオプションを取得設定します。
            /// </summary>
            [XmlAttribute]
            public string Option
            {
                get
                {
                    return this.option;
                }

                set
                {
                    this.SetProperty(ref this.option, value);
                }
            }
        }
    }
}
