﻿namespace G3dCore.Configurations
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Configurations;

    /// <summary>
    /// チームコンフィグクラスです。
    /// </summary>
    public sealed class TeamConfig : ExtensibleConfig
    {
        private string configFilePath = string.Empty;

        /// <summary>
        /// コンフィグファイルをロードします。
        /// </summary>
        /// <param name="path">コンフィグファイルのパスです。</param>
        /// <returns>ロードしたコンフィグを返します。</returns>
        public static TeamConfig Load(string path)
        {
            var config = Config.Load<TeamConfig>(path);
            if (config == null)
            {
                config = new TeamConfig();
            }

            config.configFilePath = path;

            return config;
        }

        /// <summary>
        /// コンフィグファイルを保存します。
        /// </summary>
        public override void Save()
        {
            // ツールからチームコンフィグは保存しません。
            throw new NotSupportedException();
        }

        /// <summary>
        /// コンフィグファイルのパスを取得します。
        /// </summary>
        /// <returns>コンフィグファイルのパスを返します。</returns>
        public string GetConfigFilePath()
        {
            return this.configFilePath;
        }
    }
}
