﻿namespace ShaderAssistAddons.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ViewModels;

    /// <summary>
    /// チェック付きリストアイテムのビューモデルクラスです。
    /// </summary>
    public class CheckedListItemViewModel : ViewModel
    {
        private bool? isChecked = false;
        private string label = string.Empty;
        private object tag = null;

        /// <summary>
        /// チェックされているかどうかを取得設定します。
        /// </summary>
        public bool? IsChecked
        {
            get
            {
                return this.isChecked;
            }

            set
            {
                if (value != this.isChecked)
                {
                    this.isChecked = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        /// <summary>
        /// ラベルを取得設定します。
        /// </summary>
        public string Label
        {
            get
            {
                return this.label;
            }

            set
            {
                if (value != this.label)
                {
                    this.label = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        /// <summary>
        /// タグを取得設定します。
        /// </summary>
        public object Tag
        {
            get
            {
                return this.tag;
            }

            set
            {
                if (value != this.tag)
                {
                    this.tag = value;
                    this.RaisePropertyChanged();
                }
            }
        }
    }
}
