﻿namespace ShaderAssistAddons.Modules.ShaderConfig.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using System.Windows.Shapes;
    using ShaderAssistAddons.Modules.ShaderConfig.ViewModels;

    /// <summary>
    /// ReferencePathControl.xaml の相互作用ロジック
    /// </summary>
    public partial class ReferencePathControl : UserControl
    {
        public ReferencePathControl()
        {
            InitializeComponent();
        }

        private void PathTextBox_PreviewDragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetData(DataFormats.FileDrop) != null)
            {
                e.Effects = DragDropEffects.Copy;
            }
            else
            {
                e.Effects = DragDropEffects.None;
            }

            e.Handled = true;
        }

        private void PathTextBox_Drop(object sender, DragEventArgs e)
        {
            string[] files = e.Data.GetData(DataFormats.FileDrop) as string[];
            if (files != null && files.Length > 0)
            {
                ReferencePathViewModel viewModel = (ReferencePathViewModel)this.DataContext;
                viewModel.SetPath(files[0]);
            }
        }
    }
}
