﻿namespace ShaderAssistAddons.Modules.ShaderConfig.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using System.Windows.Shapes;
    using ShaderAssistAddons.Modules.ShaderConfig.ViewModels;

    /// <summary>
    /// EditableListBoxControl.xaml の相互作用ロジック
    /// </summary>
    public partial class EditableListBoxControl : UserControl
    {
        public EditableListBoxControl()
        {
            InitializeComponent();
        }

        private void ListBox_PreviewDragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetData(DataFormats.FileDrop) != null)
            {
                e.Effects = DragDropEffects.Copy;
            }
            else
            {
                e.Effects = DragDropEffects.None;
            }

            e.Handled = true;
        }

        private void ListBox_Drop(object sender, DragEventArgs e)
        {
            string[] files = e.Data.GetData(DataFormats.FileDrop) as string[];
            if (files != null && files.Length > 0)
            {
                EditableListBoxViewModel vm = (EditableListBoxViewModel)this.DataContext;
                vm.AddToList(files);
            }
        }
    }
}
