﻿namespace ShaderAssistAddons.Modules.ShaderConfig.Views
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using Opal.App;
    using ShaderAssistAddons.Modules.ShaderConfig.Utilities;

    /// <summary>
    /// 「出力」の GridViewColumn クラスです。
    /// </summary>
    public class OutputGridViewColumn : GridViewColumn
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OutputGridViewColumn()
        {
            bool isEnabled =
                ShaderConfigUtility.GetAppMode() == G3dCore.Configurations.TeamConfigs.AppMode.AglCompatible;

            if (isEnabled)
            {
                FrameworkElementFactory ch = new FrameworkElementFactory(typeof(CheckBox));
                ch.SetBinding(CheckBox.IsCheckedProperty, new Binding("IsOutputable") { NotifyOnSourceUpdated = true });
                this.Width = 50;
                this.Header = "出力";
                this.CellTemplate = new DataTemplate() { VisualTree = ch };
            }
            else
            {
                this.Width = 0;
                this.Header = new GridViewColumnHeader()
                {
                    Visibility = Visibility.Collapsed
                };
            }
        }
    }
}
