﻿namespace ShaderAssistAddons.Modules.FileList.ViewModels
{
    using System.ComponentModel;
    using System.Diagnostics;
    using G3dCore.Storages;
    using Opal.App;
    using Opal.Services;
    using Opal.ViewModels;

    /// <summary>
    /// ファイルリストビューモデルクラスです。
    /// </summary>
    public sealed class FileListViewModel : ToolViewModel
    {
        private readonly ICollectionView fileViewModels;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public FileListViewModel()
        {
            var storageRef = AppManager.GetStorage<G3dStorage>();
            G3dStorage storage = null;
            storageRef.TryGetTarget(out storage);
            Debug.Assert(storage != null);

            this.fileViewModels = storage.FileViewModels;
        }

        /// <summary>
        /// 推奨の配置を取得します。
        /// </summary>
        public override PaneLocation PreferredLocation
        {
            get
            {
                return PaneLocation.Left;
            }
        }

        /// <summary>
        /// ファイルを取得します。
        /// </summary>
        public ICollectionView FileViewModels
        {
            get
            {
                return this.fileViewModels;
            }
        }

        /// <summary>
        /// オブジェクト破棄の内部処理です。継承した先で固有の処理を実装します。
        /// </summary>
        protected override void DisposeInternal()
        {
        }
    }
}
