﻿namespace G3dAddons.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    //using ChalkboardCore;
    using G3dAddons.Properties;
    using Opal.App;
    using Opal.Configurations;
    using Opal.Logs;
    using Opal.Menus;
    using Opal.Plugins;
    using Opal.Resources;

    /// <summary>
    /// 新規プロジェクトメニュークラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class NewProjectMenu : CommandableMenuPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public NewProjectMenu()
            : base("NewProject", Labels.NewProject, 1)
        {
            this.SetCommand(param => this.DoCommand(param), param => { return this.CanDoCommand(param); });
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public override MenuCategory Category
        {
            get
            {
                 return MenuCategory.FileNew;
            }
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        private void DoCommand(object parameter)
        {
            var logManager = AppManager.GetLogManager();
            Debug.Assert(logManager != null);

            var logger = new Logger();
            logger.Debug("New Project");

#if false
            // コンフィグから設定を取得するテスト
            {
                var weakConfig = AppManager.GetConfig<ChalkboardConfig>();
                Debug.Assert(weakConfig != null);

                ChalkboardConfig config = null;
                if (weakConfig.TryGetTarget(out config))
                {
                    foreach (var searchPath in config.SearchPaths)
                    {
                        logger.Debug(
                            string.Format(
                                "SearchPath : Name={0}, Recursive={1}, Path={2}",
                                searchPath.Name,
                                searchPath.Recursive,
                                searchPath.GetPath()));
                    }

                    // 設定を保存する場合
                    // config.Save();
                }
            }
#endif

            logManager.PushLogger(logger);
            logManager.FlushAll();
        }

        /// <summary>
        /// コマンドが実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        /// <returns>実行可能な場合は、true を返します。</returns>
        private bool CanDoCommand(object parameter)
        {
            return true;
        }
    }
}
