﻿namespace G3dAddons.Documents
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Controls;
    using G3dAddons.Modules.ShaderConfig.ViewModels;
    using G3dAddons.Modules.ShaderConfig.Views;
    using Opal.Plugins;
    using Opal.ViewModels;
    using Opal.Windows.Documents;

    /// <summary>
    /// シェーダ設定ドキュメント作成クラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public class ShaderConfigDocumentMaker : DocumentMakerPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ShaderConfigDocumentMaker()
            : base("ShaderConfig")
        {
        }

        /// <summary>
        /// ビューを生成します。
        /// </summary>
        /// <returns>ビューのインスタンスを返します。</returns>
        public override Control CreateView()
        {
            return new ShaderConfigView();
        }

        /// <summary>
        /// ビューに対応するビューモデルを生成します。
        /// </summary>
        /// <returns>ビューモデルのインスタンスを返します。</returns>
        public override DocumentViewModel CreateViewModel()
        {
            var viewModel = new ShaderConfigViewModel();
            viewModel.Title = "シェーダ設定";
            return viewModel;
        }
    }
}
