﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Xml.Serialization;
using ConfigCommon;

namespace UserConfig
{
    [Serializable]
    public class ReloadOptions
    {
        public Option Model { get; set; }
        public Option Texture { get; set; }
        public Option SkeletalAnimation { get; set; }
        public Option MaterialAnimation { get; set; }
        public Option ShaderParameterAnimation { get; set; }
        public Option ColorAnimation { get; set; }
        public Option TextureSrtAnimation { get; set; }
        public Option TexturePatternAnimation { get; set; }
        public Option BoneVisibilityAnimation { get; set; }
        public Option MaterialVisibilityAnimation { get; set; }
        public Option ShapeAnimation { get; set; }
        public Option SceneAnimation { get; set; }
        public Option ShaderDefinition { get; set; }
        public Option SeparateMaterial { get; set; }


        public ReloadOptions()
        {
            Model = new Option();
            Texture = new Option();
            SkeletalAnimation = new Option();
            ShaderParameterAnimation = new Option();
            ColorAnimation = new Option();
            TextureSrtAnimation = new Option();
            TexturePatternAnimation = new Option();
            BoneVisibilityAnimation = new Option();
            MaterialVisibilityAnimation = new Option();
            ShapeAnimation = new Option();
            SceneAnimation = new Option();
            ShaderDefinition = new Option();
            MaterialAnimation = new Option();
            SeparateMaterial = new Option();
        }

        protected bool Equals(ReloadOptions other)
        {
            return this.Model.Equals(other.Model) && this.Texture.Equals(other.Texture)
                   && this.SkeletalAnimation.Equals(other.SkeletalAnimation)
                   && this.ShaderParameterAnimation.Equals(other.ShaderParameterAnimation)
                   && this.ColorAnimation.Equals(other.ColorAnimation)
                   && this.TextureSrtAnimation.Equals(other.TextureSrtAnimation)
                   && this.TexturePatternAnimation.Equals(other.TexturePatternAnimation)
                   && this.BoneVisibilityAnimation.Equals(other.BoneVisibilityAnimation)
                   && this.MaterialVisibilityAnimation.Equals(other.MaterialVisibilityAnimation)
                   && this.SceneAnimation.Equals(other.SceneAnimation)
                   && this.ShapeAnimation.Equals(other.ShapeAnimation)
                   && this.ShaderDefinition.Equals(other.ShaderDefinition)
                   && this.MaterialAnimation.Equals(other.MaterialAnimation)
                   && this.SeparateMaterial.Equals(other.SeparateMaterial);
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj))
            {
                return false;
            }
            if (ReferenceEquals(this, obj))
            {
                return true;
            }
            if (obj.GetType() != this.GetType())
            {
                return false;
            }
            return Equals((ReloadOptions)obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = this.Model.GetHashCode();
                hashCode = (hashCode * 397) ^ this.Texture.GetHashCode();
                hashCode = (hashCode * 397) ^ this.SkeletalAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.ShaderParameterAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.ColorAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.TextureSrtAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.TexturePatternAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.BoneVisibilityAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.MaterialVisibilityAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.SceneAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.ShapeAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.ShaderDefinition.GetHashCode();
                hashCode = (hashCode * 397) ^ this.MaterialAnimation.GetHashCode();
                hashCode = (hashCode * 397) ^ this.SeparateMaterial.GetHashCode();
                return hashCode;
            }
        }

        [Serializable]
        public class Option
        {
            [XmlAttribute]
            public bool Reload { get; set; }
            [XmlAttribute]
            public bool ShowDialog { get; set; }

            public Option()
            {
                Reload = true;
                ShowDialog = false;
            }

            protected bool Equals(Option other)
            {
                return this.Reload.Equals(other.Reload) && this.ShowDialog.Equals(other.ShowDialog);
            }

            public override bool Equals(object obj)
            {
                if (ReferenceEquals(null, obj))
                {
                    return false;
                }
                if (ReferenceEquals(this, obj))
                {
                    return true;
                }
                if (obj.GetType() != this.GetType())
                {
                    return false;
                }
                return Equals((Option)obj);
            }

            public override int GetHashCode()
            {
                unchecked
                {
                    return (this.Reload.GetHashCode() * 397) ^ this.ShowDialog.GetHashCode();
                }
            }
        }
    }
}
