﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace UserConfig
{
    [Serializable]
    public class EditHistory
    {
        /// <summary>
        /// ファイルを閉じたときにコマンドスタックをクリアするか
        /// </summary>
        [XmlAttribute]
        public bool ClearAfterFileClosed = false;

        /// <summary>
        /// ファイルのリロード時にコマンドスタックをクリアするか
        /// </summary>
        [XmlAttribute]
        public bool ClearAfterFileReloaded = false;

        /// <summary>
        /// ファイルを細んした時にコマンドスタックをクリアするか
        /// </summary>
        [XmlAttribute]
        public bool ClearAfterFileSaved = false;

        /// <summary>
        /// コマンドスタックのサイズの上限
        /// </summary>
        [XmlAttribute]
        public int MaximumItemCount = 10000;
    }
}
