﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace TeamConfig
{
    [Serializable]
    public class PlatformPreset
    {
        public string Name;
        public List<DeviceOption> DeviceOptions = new List<DeviceOption>();

        [Serializable]
        public class DeviceOption
        {
            public int GLSLVersion;

            public string DeviceType;

            public string ShaderConverterAdditionalArgs;

            public string ShaderConverterAdditionalArgsForOptimizedShader;

            public string TextureConverterAdditionalArgs;

            public string PeerType;
        }

        [XmlIgnore]
        public string FilePath { get; set; }

        [XmlIgnore]
        public DeviceOption PcOption
        {
            get
            {
                return DeviceOptions.FirstOrDefault(x => x.DeviceType == "Pc");
            }
        }

        [XmlIgnore]
        public DeviceOption ActiveDeviceOption { get; set; }

        // SIGLO-76235 対応 (旧 nw 向けコードの削除対応)
        // ソースコード編集による削除ではエンバグしそうなので、常に false を返すことで対応。
        /// <summary>
        /// 旧 nw 向けコードは SIGLO-76235 にて廃止されました。
        /// 廃止に伴い、このプロパティは常に false を返します。
        /// </summary>
        [XmlIgnore]
        public bool UseNw { get { return false; } }
    }
}
