﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;
using System.Drawing;
using System.Windows.Forms;

namespace AppConfig
{
    public class PropertyEdit
    {
        [XmlAttribute]	public bool OptimizePageSize;

        [XmlAttribute]  public bool UserDataPageHexMode;

        [XmlElement]
        public int ShadingModelSubPageTabIndex;

        [XmlAttribute]
        public bool ShowConditionVariable;

        [XmlAttribute]
        public bool ShowForceReferParameter;

        [XmlAttribute]
        public bool SucceedVariable;

        [XmlAttribute]
        public bool ShowShaderParamId;

        [XmlAttribute]
        public bool ShowOriginalLabelId;

        [XmlAttribute]
        public bool FixedSlider;

        [XmlElement]
        public PageSize PropertyPageSize;

        [XmlElement]
        public PageSize ShaderPageSize;

        [XmlElement]
        public PageSize ShaderDefinitionPageSize;

        [XmlElement]
        public PageSize CurveEditorPageSize;

        [XmlElement]
        public ShaderDefinitionSourceCode ShaderDefinitionSourceCode;

        [XmlElement]
        public Point Location;

        [XmlElement]
        public ModelPreviewPage ModelPreviewPage;

        [XmlElement]
        public ShadingModelPage ShadingModelPage;

        public string ShaderParameterFilter;
        public PropertyEdit()
        {
            OptimizePageSize	= true;
            UserDataPageHexMode = false;
            ShowConditionVariable = true;
            ShowForceReferParameter = false;
            SucceedVariable = true;
            ShowShaderParamId = false;
            ShowOriginalLabelId = false;
            FixedSlider = true;
            ShadingModelSubPageTabIndex = 4;
            PropertyPageSize = new PageSize()
            {
                Width = 600,
                Height = 600,
            };
            ShaderPageSize = new PageSize();
            ShaderDefinitionPageSize = new PageSize()
            {
                Width = 800,
                Height = 500,
            };

            CurveEditorPageSize = new PageSize()
            {
                Width = 920,
                Height = 500,
            };

            ShaderDefinitionSourceCode = new ShaderDefinitionSourceCode()
            {
                AllTarget = false,
                CaseSensitive = false,
                Regex = false,
            };

            Location = new Point()
            {
                X = 200,
                Y = 200,
            };

            ModelPreviewPage = new ModelPreviewPage()
            {
                ScaleXMax = 10,
                ScaleYMax = 10,
                ScaleZMax = 10,
                RotateXMax = 360,
                RotateYMax = 360,
                RotateZMax = 360,
                TranslateXMax = 10,
                TranslateYMax = 10,
                TranslateZMax = 10,
                SortByBoneId = false,
            };

            ShadingModelPage = new ShadingModelPage();
            ShaderParameterFilter = string.Empty;
        }
    }

    public class PageSize
    {
        [XmlAttribute]
        public int Width;
        [XmlAttribute]
        public int Height;
    }

    public class ShaderDefinitionSourceCode
    {
        [XmlAttribute]
        public bool AllTarget;

        [XmlAttribute]
        public bool CaseSensitive;

        [XmlAttribute]
        public bool Regex;

        public List<string> Histories = new List<string>();
    }

    public class ModelPreviewPage
    {
        [XmlAttribute]
        public float ScaleXMax;

        [XmlAttribute]
        public float ScaleYMax;

        [XmlAttribute]
        public float ScaleZMax;

        [XmlAttribute]
        public float RotateXMax;

        [XmlAttribute]
        public float RotateYMax;

        [XmlAttribute]
        public float RotateZMax;

        [XmlAttribute]
        public float TranslateXMax;

        [XmlAttribute]
        public float TranslateYMax;

        [XmlAttribute]
        public float TranslateZMax;

        [XmlAttribute]
        public bool SortByBoneId;
    }

    public class ShadingModelPage
    {
        [XmlArrayItem("Column")]
        public List<string> MacroColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> UniformColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> BufferColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> SamplerColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> AttribColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> OptionColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> RenderInfoSlotColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> InterleaveColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> GroupColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> PageColumns = new List<string>();

        [XmlArrayItem("Column")]
        public List<string> TextBlockColumns = new List<string>();
    }
}
