﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;

namespace AppConfig
{
    using System.Linq;

    // オブジェクトビューレイアウト。
    public enum ObjectViewLayout
    {
        Single,
        Multi2Stacked,
        Multi2SideBySide,
        Multi3SplitBottom,
        Multi3SplitTop,
        Multi3SplitRight,
        Multi3SplitLeft,
        Multi4,
    }

    // オブジェクトビューモード。
    // 注意：ObjectViewMode_名前.png をリソースに追加しておく必要がある。(Undefined以外)
    public enum ObjectViewMode
    {
        Undefined,			// 未定義

        SchematicView,
        TreeView,

        ModelList,
        MaterialList,
        BoneList,
        ShapeList,
        TextureList,
    }

    public class ObjectViewLayoutSingle
    {
        [XmlAttribute]	public ObjectViewMode	Mode0;
    }

    public class ObjectViewLayoutMulti3
    {
        [XmlAttribute]	public ObjectViewMode	Mode0;
        [XmlAttribute]	public ObjectViewMode	Mode1;
        [XmlAttribute]	public ObjectViewMode	Mode2;
        [XmlAttribute]	public float			Rate0;
        [XmlAttribute]	public float			Rate1;
    }

    public class ObjectViewLayoutMulti2
    {
        [XmlAttribute]	public ObjectViewMode	Mode0;
        [XmlAttribute]	public ObjectViewMode	Mode1;
        [XmlAttribute]	public float			Rate0;
    }

    public partial class ObjectViewLayoutMulti4 {
        [XmlAttribute]	public ObjectViewMode	Mode0;
        [XmlAttribute]	public ObjectViewMode	Mode1;
        [XmlAttribute]	public ObjectViewMode	Mode2;
        [XmlAttribute]	public ObjectViewMode	Mode3;
        [XmlAttribute]	public float			Rate0;
        [XmlAttribute]	public float			Rate1;
        [XmlAttribute]	public float			Rate2;
    }

    public class ObjectView
    {
        public ObjectViewLayoutSingle Single;
        public ObjectViewLayoutMulti2 Multi2Stacked;
        public ObjectViewLayoutMulti2 Multi2SideBySide;
        public ObjectViewLayoutMulti3 Multi3SplitBottom;
        public ObjectViewLayoutMulti3 Multi3SplitTop;
        public ObjectViewLayoutMulti3 Multi3SplitRight;
        public ObjectViewLayoutMulti3 Multi3SplitLeft;
        public ObjectViewLayoutMulti4 Multi4;

        [XmlAttribute]
        public ObjectViewLayout	Layout;

        public ListView ModelListView;
        public ListView ShapeListView;
        public ListView BoneListView;
        public ListView TextureListView;
        public ListView MaterialListView;

        public ObjectView()
        {
            this.Initialize();
        }

        public ObjectView(bool initialize)
        {
            if (initialize)
            {
                this.Initialize();
            }
        }

        private void Initialize()
        {
            // 全レイアウトの初期配置をここで設定

            // １画面
            this.Single = new ObjectViewLayoutSingle { Mode0 = ObjectViewMode.SchematicView };
            // ２画面（上下）
            this.Multi2Stacked = new ObjectViewLayoutMulti2
                                     {
                                         Mode0 = ObjectViewMode.SchematicView,
                                         Mode1 = ObjectViewMode.MaterialList,
                                         Rate0 = 0.5f
                                     };
            // ２画面（左右）
            this.Multi2SideBySide = new ObjectViewLayoutMulti2
                                        {
                                            Mode0 = ObjectViewMode.SchematicView,
                                            Mode1 = ObjectViewMode.MaterialList,
                                            Rate0 = 0.5f
                                        };
            // ３画面（下を分割）
            this.Multi3SplitBottom = new ObjectViewLayoutMulti3
                                         {
                                             Mode0 = ObjectViewMode.SchematicView,
                                             Mode1 = ObjectViewMode.MaterialList,
                                             Mode2 = ObjectViewMode.ModelList,
                                             Rate0 = 0.5f,
                                             Rate1 = 0.5f
                                         };
            // ３画面（上を分割）
            this.Multi3SplitTop = new ObjectViewLayoutMulti3
                                      {
                                          Mode0 = ObjectViewMode.SchematicView,
                                          Mode1 = ObjectViewMode.MaterialList,
                                          Mode2 = ObjectViewMode.ModelList,
                                          Rate0 = 0.5f,
                                          Rate1 = 0.5f
                                      };
            // ３画面（右を分割）
            this.Multi3SplitRight = new ObjectViewLayoutMulti3
                                        {
                                            Mode0 = ObjectViewMode.SchematicView,
                                            Mode1 = ObjectViewMode.MaterialList,
                                            Mode2 = ObjectViewMode.ModelList,
                                            Rate0 = 0.5f,
                                            Rate1 = 0.5f
                                        };
            // ３画面（左を分割）
            this.Multi3SplitLeft = new ObjectViewLayoutMulti3
                                       {
                                           Mode0 = ObjectViewMode.SchematicView,
                                           Mode1 = ObjectViewMode.MaterialList,
                                           Mode2 = ObjectViewMode.ModelList,
                                           Rate0 = 0.5f,
                                           Rate1 = 0.5f
                                       };
            // ４画面
            this.Multi4 = new ObjectViewLayoutMulti4
                              {
                                  Mode0 = ObjectViewMode.SchematicView,
                                  Mode1 = ObjectViewMode.MaterialList,
                                  Mode2 = ObjectViewMode.ModelList,
                                  Mode3 = ObjectViewMode.BoneList,
                                  Rate0 = 0.5f,
                                  Rate1 = 0.5f,
                                  Rate2 = 0.5f
                              };
            // 列項目を初期化
            this.ModelListView = new ListView();
            this.ShapeListView = new ListView();
            this.TextureListView = new ListView();
            this.BoneListView = new ListView();
            this.MaterialListView = new ListView();
        }
    }

    public class ListView
    {
        [XmlElement("Column")]
        public List<Column> Columns;

        [XmlElement("Filter")]
        public string Filter;

        public ListView()
        {
            Columns = new List<Column>();
        }

        public ListView Clone()
        {
            var listview = new ListView { Filter = this.Filter };
            foreach (var column in Columns)
            {
                listview.Columns.Add(column.Clone());
            }
            return listview;
        }
    }

    public class Column
    {
        [XmlAttribute]
        public string Name { get; set; }

        [XmlAttribute]
        public bool Show { get; set; }

        [XmlAttribute]
        public int Width
        {
            get
            {
                if (columnItem != null)
                {
                    return columnItem.Width;
                }
                return width;
            }
            set
            {
                width = value;
            }
        }

        [XmlAttribute]
        public string Id { get; set; }

        [XmlAttribute]
        public string Type { get; set; }

        [XmlIgnore]
        public int width = -1;		// 直接アクセスしない。コンフィグ用

        [XmlIgnore]
        public bool DefaultShow;

        [XmlIgnore]
        public IColumnItem columnItem;

        [XmlIgnore]
        public int DefaultOrder;

        [XmlIgnore]
        public string Category;

        [XmlIgnore]
        public string Text;

        public interface IColumnItem
        {
            int Width{ get; }
        }

        public Column Clone()
        {
            return (Column)MemberwiseClone();
        }
    }
}
