﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Drawing;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace AppConfig
{
    public class MainFrame
    {
        [XmlAttribute]	public bool Maximized;
        [XmlAttribute]	public bool ToolBar;
        [XmlAttribute]	public bool StatusBar;
        [XmlAttribute]	public bool LogBar;
        [XmlAttribute]	public int  FileViewWidth;
        [XmlAttribute]	public int  FileViewHeight;
        [XmlAttribute]	public int  LogListHeight;
        [XmlAttribute]	public bool LogListCollapsed;

        [XmlAttribute]	public int X;
        [XmlAttribute]	public int Y;
        [XmlAttribute]	public int Width;
        [XmlAttribute]	public int Height;

        [XmlAttribute]	public bool IsAutoAnimationBindMode;
        [XmlAttribute]	public int ViewAlignMode;

        [XmlAttribute]
        public string ShaderParameterFilter;

        // TODO: Preview のほうが適当そうなので落ち着いたら変更
        [XmlAttribute]
        public string SelectedSpec;

        [XmlArrayItem("Path")]
        public string[] MostRecentlyUsedFiles;

        [XmlArrayItem("Path")]
        public string[] MostRecentlyUsedProjects;

        public MainFrame()
        {
            Maximized			= false;
            ToolBar				= true;
            StatusBar			= true;
            LogBar				= true;
            FileViewWidth		= 250;
            FileViewHeight		= 500;
            LogListHeight		= 704;
            LogListCollapsed	= false;

            Width  = 1000;
            Height = 800;
            X      = (SystemInformation.WorkingArea.Width  - Width) / 2;
            Y      = (SystemInformation.WorkingArea.Height - Height) / 2;

            IsAutoAnimationBindMode	= false;
            ViewAlignMode = 0;

            ShaderParameterFilter = null;

            MostRecentlyUsedFiles = new string[0];
            MostRecentlyUsedProjects = new string[0];

            SelectedSpec = string.Empty;
        }
    }
}
