﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using ConfigCommon;

namespace AppConfig
{
    public class CurveEditor
    {
        [XmlAttribute]	public double FrameSnapFactor	{ get; set; }
        [XmlAttribute]	public double ValueSnapFactor	{ get; set; }
        [XmlAttribute]  public double KeySnapFactor { get; set; }

        [XmlAttribute]	public PasteMethodType		PasteMethod		{ get; set; }
        [XmlAttribute]	public PastePositionType	PastePosition	{ get; set; }

        [XmlAttribute]	public bool IsVisibleFrameValue		{ get; set; }
        [XmlAttribute]	public bool IsVisibleSlope			{ get; set; }
        [XmlAttribute]	public bool IsVisibleMinMax			{ get; set; }
        [XmlAttribute]	public bool IsVisibleCurrentValue	{ get; set; }
        [XmlAttribute]  public bool IsVisibleCurveName      { get; set; }
        [XmlAttribute]	public bool IsClampCurrentFrame		{ get; set; }
        [XmlAttribute]  public bool IsAutoSplineSlope { get; set; }

        [XmlAttribute]	public bool IsAllShowNode					{ get; set; }
        [XmlAttribute]	public bool IsShaderParamAnimGroupCondShow	{ get; set; }
        [XmlAttribute]	public bool IsOnlyTargetShowNode			{ get; set; }
        [XmlAttribute]  public bool IsSortByAlphabetical            { get; set; }
        [XmlAttribute]	public bool IsClampFrame					{ get; set; }
        [XmlAttribute]	public bool IsClampValue					{ get; set; }
        [XmlAttribute]  public bool IsSnapToOtherKey                { get; set; }
        [XmlAttribute]  public bool IsShowKeyedMaterial             { get; set; }

        public ToolStripLocationType ToolStripLocation
        {
            get;
            set;
        }

        public class ToolStripLocationType
        {
            // 初期値
            public ToolStripLocationType()
            {
                // 初期値
                Edit		= new State() {
                    Location = new Point(0, 0),
                };
                Fit = new State() {
                    Location = new Point(410, 0)
                };
                KeyFrame	= new State()
                {
                    Location = new Point(0, 26),
                };
                Play		= new State()
                {
                    Location = new Point(514, 0),
                };
                Paste =new State()
                {
                    Location = new Point(572, 0)
                };
                Snap = new State()
                {
                    Location = new Point(445, 26)
                };
            }

            public State Edit { get; set; }
            public State Fit { get; set; }
            public State KeyFrame { get; set; }
            public State Play { get; set; }
            public State Paste { get; set; }
            public State Snap { get; set; }

            public class State
            {
                public Point Location { get; set; }
                public bool Collapsed { get; set; }
            }
        }

        public CurveEditor()
        {
            // 初期値
            FrameSnapFactor					= 1.0;
            ValueSnapFactor					= 0.01;
            KeySnapFactor                   = 16.0;
            PasteMethod						= PasteMethodType.Insert;
            PastePosition					= PastePositionType.Relative;
            IsVisibleFrameValue				= false;
            IsVisibleSlope					= false;
            IsVisibleMinMax					= false;
            IsVisibleCurrentValue			= false;
            IsClampCurrentFrame				= true;
            IsAllShowNode					= true;
            IsShaderParamAnimGroupCondShow	= false;
            IsOnlyTargetShowNode			= false;
            IsClampFrame					= false;
            IsClampValue					= false;
            IsSnapToOtherKey                = false;
            ToolStripLocation = new ToolStripLocationType();
        }
    }
}
