﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace Bridge
{

    public class BridgeInfo : MarshalByRefObject
    {
        public const string IpcChannelName	= "3dEditorBridge_IPC_CHANNEL";
        public const string IpcUrl			= "3dEditorBridge_IPC_URL";

        public enum ModeType
        {
            ExportInfo,				// 3DEditor 側の情報の書き出し
            ExportTemporaryFiles,	// 3DEditor 編集状態を一時中間ファイルに出力
            ReloadTemporaryFiles,	// 一時中間ファイルを 3DEditor に再読み込み
            LoadFiles, // ファイルの読み込み
            SaveFiles, // ファイルの保存
            SaveAll, // 全て保存
            CloseAll, // 全て閉じる
            OptimizeShader,  // シェーダー最適化の有効/無効を切り替え
            Connect, // 接続
            Disconnect, // 切断
            ClearHistory, // 履歴を消去
            Start3DEditor, // 3DEditor を起動
            Close3DEditor, // 3DEditor を終了
            QueryConnectionState // 接続状態を返す
        }

        public class Result : MarshalByRefObject
        {
            // タイプを変更したら Bridge.cs の ShowResult も修正すること
            public enum ResultType
            {
                CannotWrite,	// ファイル書き込み失敗
                CannotRead, // ファイル読み込み失敗
                FileNotFoundIn3DEditor,	// ファイルが見つからない
                //CanceledForShowingModalDialog, // モーダルダイアログ表示中のためキャンセル
                FileDuplicated, // 同名のファイルが複数あるため処理をスキップ
                FailedToConnect, // ランタイムへの接続に失敗
                AlreadyConnected, // 既に接続されていた
                FailedToDisconnect, // 切断に失敗
                AlreadyDisconnect, // 既に切断されていた
                Information, // 情報メッセージ
                Warning, // 警告メッセージ
                Error, // エラーメッセージ
                ConnectionIdle, // 接続待機中
                ConnectionBusy, // 接続通信中
                Disconnected, // 切断中
            }

            public ResultType	Type	{ get; set; }
            public string		Message	{ get; set; }
            public bool error { get; set; }

            public Result()
            {
                Message = string.Empty;
                error = true;
            }
        }

        //----------------------------------------------------------------------
        // プロパティを追加したら Bridge.cs の WriteBridgeInfo も修正すること !!

        // Bridge側から3DEditor側へ
        public ModeType		Mode	{ get; set; }
        public string		Output	{ get; set; }
        public string		Path	{ get; set; }
        public List<string>	Files	{ get; set; }
        public bool ForceUnloadAndLoad { get; set; }
        public string WorkingDirectory { get; set; }
        public bool IsDeviceTarget { get; set; }
        public string Platform { get; set; }
        public bool DisableOptimizeShader { get; set; }
        public bool DisableFileInfo { get; set; }

        // 3DEditor側からBridge側へ
        public List<Result>	Results		{ get; set; }		// 3DEditor側の結果
        public bool			IsReceived	{ get; set; }		// 3DEditor側がうけとったか？
        public bool			exception	{ get; set; }		// 3DEditor 側で例外

        public event EventHandler Wrote;
        public void OnWrote()
        {
            if (Wrote != null)
            {
                Wrote(this, EventArgs.Empty);
            }
        }

        public override string ToString()
        {
            return string.Format("Mode:{0} Output:{1} Path:{2} IsReceived:{3}", Mode, Output, Path, IsReceived);
        }

        public override object InitializeLifetimeService()
        {
            // こうしないと5分で接続できなくなる。
            // http://stackoverflow.com/questions/2651852/requested-service-not-found
            return null;
        }
    }
}
