﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using NintendoWare.G3d.Edit;
using nw.g3d.nw4f_3dif;

namespace Viewer
{
    static partial class HioUtility
    {
        private static readonly Dictionary<render_state_display_faceType, HIO.MaterialDisplayFaceKind> materialDisplayFaceKindDict_ = new Dictionary<render_state_display_faceType, HIO.MaterialDisplayFaceKind>()
        {
            {render_state_display_faceType.both,	HIO.MaterialDisplayFaceKind.Both},
            {render_state_display_faceType.front,	HIO.MaterialDisplayFaceKind.Front},
            {render_state_display_faceType.back,	HIO.MaterialDisplayFaceKind.Back},
            {render_state_display_faceType.none,	HIO.MaterialDisplayFaceKind.None},
        };

        private static readonly Dictionary<alpha_test_funcType, HIO.AlphaTestFuncKind> alphaTestFuncKindDict_ = new Dictionary<alpha_test_funcType, HIO.AlphaTestFuncKind>()
        {
            {alpha_test_funcType.never,			HIO.AlphaTestFuncKind.Never},
            {alpha_test_funcType.less,			HIO.AlphaTestFuncKind.Less},
            {alpha_test_funcType.equal,			HIO.AlphaTestFuncKind.Equal},
            {alpha_test_funcType.lequal,		HIO.AlphaTestFuncKind.LessEqual},
            {alpha_test_funcType.greater,		HIO.AlphaTestFuncKind.Greater},
            {alpha_test_funcType.nequal,		HIO.AlphaTestFuncKind.NotEqual},
            {alpha_test_funcType.gequal,		HIO.AlphaTestFuncKind.GreaterEqual},
            {alpha_test_funcType.always,		HIO.AlphaTestFuncKind.Always},
        };

        private static readonly Dictionary<depth_test_funcType, HIO.DepthTestFuncKind> depthTestFuncKindDict_ = new Dictionary<depth_test_funcType, HIO.DepthTestFuncKind>()
        {
            {depth_test_funcType.never,			HIO.DepthTestFuncKind.Never},
            {depth_test_funcType.less,			HIO.DepthTestFuncKind.Less},
            {depth_test_funcType.equal,			HIO.DepthTestFuncKind.Equal},
            {depth_test_funcType.lequal,		HIO.DepthTestFuncKind.LessEqual},
            {depth_test_funcType.greater,		HIO.DepthTestFuncKind.Greater},
            {depth_test_funcType.nequal,		HIO.DepthTestFuncKind.NotEqual},
            {depth_test_funcType.gequal,		HIO.DepthTestFuncKind.GreaterEqual},
            {depth_test_funcType.always,		HIO.DepthTestFuncKind.Always},
        };

        private static readonly Dictionary<color_blend_opType, HIO.BlendCombineKind> blendCombineKindDict_ = new Dictionary<color_blend_opType, HIO.BlendCombineKind>()
        {
            {color_blend_opType.add,				HIO.BlendCombineKind.Add},
            {color_blend_opType.src_minus_dst,		HIO.BlendCombineKind.SrcMinusDst},
            {color_blend_opType.min,				HIO.BlendCombineKind.Min},
            {color_blend_opType.max,				HIO.BlendCombineKind.Max},
            {color_blend_opType.dst_minus_src,		HIO.BlendCombineKind.DstMinusSrc},
        };

        private static readonly Dictionary<color_blend_rgb_funcType, HIO.ColorBlendFuncKind> colorBlendFuncKindDict_ = new Dictionary<color_blend_rgb_funcType, HIO.ColorBlendFuncKind>()
        {
            {color_blend_rgb_funcType.zero,							HIO.ColorBlendFuncKind.Zero},
            {color_blend_rgb_funcType.one,							HIO.ColorBlendFuncKind.One},
            {color_blend_rgb_funcType.src_color,					HIO.ColorBlendFuncKind.SrcColor},
            {color_blend_rgb_funcType.one_minus_src_color,			HIO.ColorBlendFuncKind.OneMinusSrcColor},
            {color_blend_rgb_funcType.src_alpha,					HIO.ColorBlendFuncKind.SrcAlpha},
            {color_blend_rgb_funcType.one_minus_src_alpha,			HIO.ColorBlendFuncKind.OneMinusSrcAlpha},
            {color_blend_rgb_funcType.dst_alpha,					HIO.ColorBlendFuncKind.DstAlpha},
            {color_blend_rgb_funcType.one_minus_dst_alpha,			HIO.ColorBlendFuncKind.OneMinusDstAlpha},
            {color_blend_rgb_funcType.dst_color,					HIO.ColorBlendFuncKind.DstColor},
            {color_blend_rgb_funcType.one_minus_dst_color,			HIO.ColorBlendFuncKind.OneMinusDstColor},
            {color_blend_rgb_funcType.src_alpha_saturate,			HIO.ColorBlendFuncKind.SrcAlphaSaturate},
            {color_blend_rgb_funcType.const_color,					HIO.ColorBlendFuncKind.ConstantColor},
            {color_blend_rgb_funcType.one_minus_const_color,		HIO.ColorBlendFuncKind.OneMinusConstantColor},
            {color_blend_rgb_funcType.src1_color,					HIO.ColorBlendFuncKind.Src1Color},
            {color_blend_rgb_funcType.one_minus_src1_color,			HIO.ColorBlendFuncKind.OneMinusSrc1Color},
            {color_blend_rgb_funcType.src1_alpha,					HIO.ColorBlendFuncKind.Src1Alpha},
            {color_blend_rgb_funcType.one_minus_src1_alpha,			HIO.ColorBlendFuncKind.OneMinusSrc1Alpha},
            {color_blend_rgb_funcType.const_alpha,					HIO.ColorBlendFuncKind.ConstantAlpha},
            {color_blend_rgb_funcType.one_minus_const_alpha,		HIO.ColorBlendFuncKind.OneMinusConstantAlpha},
        };

        private static readonly Dictionary<color_blend_alpha_funcType, HIO.AlphaBlendFuncKind> alphaBlendFuncKindDict_ = new Dictionary<color_blend_alpha_funcType, HIO.AlphaBlendFuncKind>()
        {
            {color_blend_alpha_funcType.zero,						HIO.AlphaBlendFuncKind.Zero},
            {color_blend_alpha_funcType.one,						HIO.AlphaBlendFuncKind.One},
            {color_blend_alpha_funcType.src_alpha,					HIO.AlphaBlendFuncKind.SrcAlpha},
            {color_blend_alpha_funcType.one_minus_src_alpha,		HIO.AlphaBlendFuncKind.OneMinusSrcAlpha},
            {color_blend_alpha_funcType.dst_alpha,					HIO.AlphaBlendFuncKind.DstAlpha},
            {color_blend_alpha_funcType.one_minus_dst_alpha,		HIO.AlphaBlendFuncKind.OneMinusDstAlpha},
            {color_blend_alpha_funcType.src_alpha_saturate,			HIO.AlphaBlendFuncKind.SrcAlphaSaturate},
            {color_blend_alpha_funcType.src1_alpha,					HIO.AlphaBlendFuncKind.Src1Alpha},
            {color_blend_alpha_funcType.one_minus_src1_alpha,		HIO.AlphaBlendFuncKind.OneMinusSrc1Alpha},
            {color_blend_alpha_funcType.const_alpha,				HIO.AlphaBlendFuncKind.ConstantAlpha},
            {color_blend_alpha_funcType.one_minus_const_alpha,		HIO.AlphaBlendFuncKind.OneMinusConstantAlpha},
        };

        private static readonly Dictionary<render_state_modeType, HIO.RenderStateMode> renderStateModeDict_ = new Dictionary<render_state_modeType, HIO.RenderStateMode>()
        {
            {render_state_modeType.custom,		HIO.RenderStateMode.Custom},
            {render_state_modeType.opaque,		HIO.RenderStateMode.Opaque},
            {render_state_modeType.mask,		HIO.RenderStateMode.Mask},
            {render_state_modeType.translucent,	HIO.RenderStateMode.Translucent},
        };

        private static readonly Dictionary<render_state_blend_modeType, HIO.BlendMode> blendModeDict_ = new Dictionary<render_state_blend_modeType, HIO.BlendMode>()
        {
            {render_state_blend_modeType.none,	HIO.BlendMode.None},
            {render_state_blend_modeType.color,	HIO.BlendMode.Color},
            {render_state_blend_modeType.logic,	HIO.BlendMode.Logic},
        };

        private static readonly Dictionary<logical_blend_opType, HIO.LogicOpKind> logicOpKindDict_ = new Dictionary<logical_blend_opType, HIO.LogicOpKind>()
        {
            {logical_blend_opType.clear,		HIO.LogicOpKind.Clear},
            {logical_blend_opType.set,			HIO.LogicOpKind.Set},
            {logical_blend_opType.copy,			HIO.LogicOpKind.Copy},
            {logical_blend_opType.inv_copy,		HIO.LogicOpKind.InvCopy},
            {logical_blend_opType.no_op,		HIO.LogicOpKind.NoOp},
            {logical_blend_opType.inv,			HIO.LogicOpKind.Inv},
            {logical_blend_opType.and,			HIO.LogicOpKind.And},
            {logical_blend_opType.nand,			HIO.LogicOpKind.NotAnd},
            {logical_blend_opType.or,			HIO.LogicOpKind.Or},
            {logical_blend_opType.nor,			HIO.LogicOpKind.NotOr},
            {logical_blend_opType.xor,			HIO.LogicOpKind.XOr},
            {logical_blend_opType.equiv,		HIO.LogicOpKind.Equiv},
            {logical_blend_opType.rev_and,		HIO.LogicOpKind.RevAnd},
            {logical_blend_opType.inv_and,		HIO.LogicOpKind.InvAnd},
            {logical_blend_opType.rev_or,		HIO.LogicOpKind.RevOr},
            {logical_blend_opType.inv_or,		HIO.LogicOpKind.InvOr},
        };

        private static readonly Dictionary<wrap_uvwType, HIO.TextureClampKind> textureClampKindDict_ = new Dictionary<wrap_uvwType, HIO.TextureClampKind>()
        {
            {wrap_uvwType.repeat,		HIO.TextureClampKind.Repeat},
            {wrap_uvwType.mirror,		HIO.TextureClampKind.Mirror},
            {wrap_uvwType.clamp,		HIO.TextureClampKind.Clamp},
            {wrap_uvwType.mirror_once,	HIO.TextureClampKind.MirrorOnce},
        };

        private static readonly Dictionary<filter_mag_minType, HIO.TextureFilterKind> texturFilterKindDict_ = new Dictionary<filter_mag_minType, HIO.TextureFilterKind>()
        {
            {filter_mag_minType.point,	HIO.TextureFilterKind.Point},
            {filter_mag_minType.linear,	HIO.TextureFilterKind.Linear},
        };

        private static readonly Dictionary<filter_mipType, HIO.TextureFilterKind> textureMipFilterKindDict_ = new Dictionary<filter_mipType, HIO.TextureFilterKind>()
        {
            {filter_mipType.none,	HIO.TextureFilterKind.None},
            {filter_mipType.point,	HIO.TextureFilterKind.Point},
            {filter_mipType.linear,	HIO.TextureFilterKind.Linear},
        };

        private static readonly Dictionary<filter_max_anisoType, HIO.TextureAnisoRatioKind> textureAnisoRatioKindDict_ = new Dictionary<filter_max_anisoType, HIO.TextureAnisoRatioKind>()
        {
            {filter_max_anisoType.aniso_1,	HIO.TextureAnisoRatioKind.Aniso1},
            {filter_max_anisoType.aniso_2,	HIO.TextureAnisoRatioKind.Aniso2},
            {filter_max_anisoType.aniso_4,	HIO.TextureAnisoRatioKind.Aniso4},
            {filter_max_anisoType.aniso_8,	HIO.TextureAnisoRatioKind.Aniso8},
            {filter_max_anisoType.aniso_16,	HIO.TextureAnisoRatioKind.Aniso16},
        };

        private static readonly Dictionary<filter_max_anisoType, int> textureAnisoRationKindToInt_ = new Dictionary<filter_max_anisoType, int>()
        {
            {filter_max_anisoType.aniso_1,	1},
            {filter_max_anisoType.aniso_2,	2},
            {filter_max_anisoType.aniso_4,	4},
            {filter_max_anisoType.aniso_8,	8},
            {filter_max_anisoType.aniso_16,	16},
        };
    }
}
