﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace App.Win32
{
    //---------------------------------------------------------------------
    // WinDef.h
    //---------------------------------------------------------------------
    #region RECT
    /// <summary>
    /// RECT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct RECT
    {
        /// <summary></summary>
        public int	left;
        /// <summary></summary>
        public int	top;
        /// <summary></summary>
        public int	right;
        /// <summary></summary>
        public int	bottom;

        // typedef struct tagRECT
        // {
        //     LONG    left;
        //     LONG    top;
        //     LONG    right;
        //     LONG    bottom;
        // } RECT, *PRECT, NEAR *NPRECT, FAR *LPRECT;

        /// <summary>
        /// Rectangle型に変換。
        /// </summary>
        public Rectangle ToRectangle() { return new Rectangle(left, top, right - left, bottom - top); }
    }
    #endregion

    #region POINT
    /// <summary>
    /// POINT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct POINT
    {
        /// <summary></summary>
        public int	x;
        /// <summary></summary>
        public int	y;

        // typedef struct tagPOINT
        // {
        //     LONG  x;
        //     LONG  y;
        // } POINT, *PPOINT, NEAR *NPPOINT, FAR *LPPOINT;

        /// <summary>
        /// Point型に変換。
        /// </summary>
        public Point ToPoint() { return new Point(x, y); }
    }
    #endregion

    //---------------------------------------------------------------------
    // WinUser.h
    //---------------------------------------------------------------------
    #region WINDOWPLACEMENT
    /// <summary>
    /// WINDOWPLACEMENT 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct WINDOWPLACEMENT
    {
        /// <summary></summary>
        public int		length;
        /// <summary></summary>
        public int		flags;
        /// <summary></summary>
        public int		showCmd;
        /// <summary></summary>
        public POINT	ptMinPosition;
        /// <summary></summary>
        public POINT	ptMaxPosition;
        /// <summary></summary>
        public RECT		rcNormalPosition;

        // typedef struct tagWINDOWPLACEMENT {
        //     UINT  length;
        //     UINT  flags;
        //     UINT  showCmd;
        //     POINT ptMinPosition;
        //     POINT ptMaxPosition;
        //     RECT  rcNormalPosition;
        // #ifdef _MAC
        //     RECT  rcDevice;
        // #endif
        // } WINDOWPLACEMENT;
        // typedef WINDOWPLACEMENT *PWINDOWPLACEMENT, *LPWINDOWPLACEMENT;
    }
    #endregion

    #region NMHDR
    /// <summary>
    /// NMHDR 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct NMHDR
    {
        /// <summary></summary>
        public IntPtr	hwndFrom;
        /// <summary></summary>
        public int		idFrom;
        /// <summary></summary>
        public int		code;         // NM_ code

        // typedef struct tagNMHDR
        // {
        //     HWND      hwndFrom;
        //     UINT_PTR  idFrom;
        //     UINT      code;
        // } NMHDR;
    }
    #endregion

    //---------------------------------------------------------------------
    // CommCtrl.h
    //---------------------------------------------------------------------
    #region NMHEADER
    /// <summary>
    /// NMHEADER 構造体。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct NMHEADER
    {
        /// <summary></summary>
        public NMHDR	hdr;
        /// <summary></summary>
        public int		iItem;
        /// <summary></summary>
        public int		iButton;
        /// <summary></summary>
        public IntPtr	pitem;

        // typedef struct tagNMHEADERW
        // {
        //     NMHDR   hdr;
        //     int     iItem;
        //     int     iButton;
        //     HDITEMW *pitem;
        // } NMHEADERW, *LPNMHEADERW;
    }
    #endregion

    // 将来のGLコンテキストの生成破棄への対応のため
    [StructLayout(LayoutKind.Sequential)]
    public struct PIXELFORMATDESCRIPTOR
    {
        public short nSize;
        public short nVersion;
        public uint dwFlags;
        public byte iPixelType;
        public byte cColorBits;
        public byte cRedBits;
        public byte cRedShift;
        public byte cGreenBits;
        public byte cGreenShift;
        public byte cBlueBits;
        public byte cBlueShift;
        public byte cAlphaBits;
        public byte cAlphaShift;
        public byte cAccumBits;
        public byte cAccumRedBits;
        public byte cAccumGreenBits;
        public byte cAccumBlueBits;
        public byte cAccumAlphaBits;
        public byte cDepthBits;
        public byte cStencilBits;
        public byte cAuxBuffers;
        public byte iLayerType;
        public byte bReserved;
        public uint dwLayerMask;
        public uint dwVisibleMask;
        public uint dwDamageMask;

        //typedef struct tagPIXELFORMATDESCRIPTOR {
        //    WORD  nSize;
        //    WORD  nVersion;
        //    DWORD dwFlags;
        //    BYTE  iPixelType;
        //    BYTE  cColorBits;
        //    BYTE  cRedBits;
        //    BYTE  cRedShift;
        //    BYTE  cGreenBits;
        //    BYTE  cGreenShift;
        //    BYTE  cBlueBits;
        //    BYTE  cBlueShift;
        //    BYTE  cAlphaBits;
        //    BYTE  cAlphaShift;
        //    BYTE  cAccumBits;
        //    BYTE  cAccumRedBits;
        //    BYTE  cAccumGreenBits;
        //    BYTE  cAccumBlueBits;
        //    BYTE  cAccumAlphaBits;
        //    BYTE  cDepthBits;
        //    BYTE  cStencilBits;
        //    BYTE  cAuxBuffers;
        //    BYTE  iLayerType;
        //    BYTE  bReserved;
        //    DWORD dwLayerMask;
        //    DWORD dwVisibleMask;
        //    DWORD dwDamageMask;
        //} PIXELFORMATDESCRIPTOR, *PPIXELFORMATDESCRIPTOR;
    }
}
