﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace App.Win32
{
    internal sealed class NativeMethods
    {
        // user32.dll
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool AdjustWindowRect(ref RECT lpRect, int dwStyle, bool bMenu);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool AdjustWindowRectEx(ref RECT lpRect, int dwStyle, bool bMenu, int dwExStyle);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool DrawFocusRect(IntPtr hDC, ref RECT lprc);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool GetClientRect(IntPtr hWnd, ref RECT lpRect);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool GetUpdateRect(IntPtr hWnd, ref RECT lpRect, bool bErase);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr GetWindowDC(IntPtr hWnd);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern int GetWindowLong(IntPtr hWnd, int nIndex);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern int SetWindowLong(IntPtr hWnd, int nIndex, int dwNewLong);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool GetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool SetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool GetWindowRect(IntPtr hWnd, ref RECT lpRect);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool RedrawWindow(IntPtr hWnd, ref RECT lprcUpdate, IntPtr hrgnUpdate, int flags);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr GetDC(IntPtr hWnd) ;

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern int ReleaseDC(IntPtr hWnd, IntPtr hDC);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, int lParam);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, ref RECT lParam);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, int[] lParam);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr SendMessage(IntPtr hwnd, int msg, IntPtr wParam, ref Rect lParam);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr SendMessage(IntPtr hwnd, int msg, IntPtr wParam, ref COPYDATASTRUCT lParam);

        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr SendMessage(IntPtr hwnd, int msg, IntPtr wParam, ref Point lParam);

        [StructLayout(LayoutKind.Sequential)]
        internal struct Rect
        {
            public int Left;
            public int Top;
            public int Right;
            public int Bottom;
        }

        [StructLayout(LayoutKind.Sequential)]
        internal struct COPYDATASTRUCT
        {
            public const int DataLength = 256;

            public IntPtr	dwData;
            public int		cbData;

            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = DataLength)]
            public string	lpData;
        }

        [DllImport("user32.dll")]
        internal static extern short GetAsyncKeyState(int vKey);

        [DllImport("user32.dll")]
        internal static extern bool LockWindowUpdate(IntPtr hWhd);

        [DllImport("user32.dll")]
        internal static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("user32.dll")]
        internal static extern bool ShowWindowAsync(IntPtr hWnd,int nCmdShow);

        [DllImport("user32.dll")]
        internal static extern bool ShowWindow(IntPtr hWnd,int nCmdShow);

        [DllImport("user32.dll")]
        internal static extern bool IsIconic(IntPtr hWnd);

        [DllImport("user32.dll")]
        internal static extern int GetSystemMetrics(SystemMetric smIndex);

        internal enum SystemMetric : int
        {
            SM_CXSCREEN = 0,
            SM_CYSCREEN = 1,
            SM_CYVSCROLL = 2,
            SM_CXVSCROLL = 3,
            SM_CYCAPTION = 4,
            SM_CXBORDER = 5,
            SM_CYBORDER = 6,
            SM_CXDLGFRAME = 7,
            SM_CYDLGFRAME = 8,
            SM_CYVTHUMB = 9,
            SM_CXHTHUMB = 10,
            SM_CXICON = 11,
            SM_CYICON = 12,
            SM_CXCURSOR = 13,
            SM_CYCURSOR = 14,
            SM_CYMENU = 15,
            SM_CXFULLSCREEN = 16,
            SM_CYFULLSCREEN = 17,
            SM_CYKANJIWINDOW = 18,
            SM_MOUSEWHEELPRESENT = 75,
            SM_CYHSCROLL = 20,
            SM_CXHSCROLL = 21,
            SM_DEBUG = 22,
            SM_SWAPBUTTON = 23,
            SM_RESERVED1 = 24,
            SM_RESERVED2 = 25,
            SM_RESERVED3 = 26,
            SM_RESERVED4 = 27,
            SM_CXMIN = 28,
            SM_CYMIN = 29,
            SM_CXSIZE = 30,
            SM_CYSIZE = 31,
            SM_CXFRAME = 32,
            SM_CYFRAME = 33,
            SM_CXMINTRACK = 34,
            SM_CYMINTRACK = 35,
            SM_CXDOUBLECLK = 36,
            SM_CYDOUBLECLK = 37,
            SM_CXICONSPACING = 38,
            SM_CYICONSPACING = 39,
            SM_MENUDROPALIGNMENT = 40,
            SM_PENWINDOWS = 41,
            SM_DBCSENABLED = 42,
            SM_CMOUSEBUTTONS = 43,
            SM_CXFIXEDFRAME = SM_CXDLGFRAME,
            SM_CYFIXEDFRAME = SM_CYDLGFRAME,
            SM_CXSIZEFRAME = SM_CXFRAME,
            SM_CYSIZEFRAME = SM_CYFRAME,
            SM_SECURE = 44,
            SM_CXEDGE = 45,
            SM_CYEDGE = 46,
            SM_CXMINSPACING = 47,
            SM_CYMINSPACING = 48,
            SM_CXSMICON = 49,
            SM_CYSMICON = 50,
            SM_CYSMCAPTION = 51,
            SM_CXSMSIZE = 52,
            SM_CYSMSIZE = 53,
            SM_CXMENUSIZE = 54,
            SM_CYMENUSIZE = 55,
            SM_ARRANGE = 56,
            SM_CXMINIMIZED = 57,
            SM_CYMINIMIZED = 58,
            SM_CXMAXTRACK = 59,
            SM_CYMAXTRACK = 60,
            SM_CXMAXIMIZED = 61,
            SM_CYMAXIMIZED = 62,
            SM_NETWORK = 63,
            SM_CLEANBOOT = 67,
            SM_CXDRAG = 68,
            SM_CYDRAG = 69,
            SM_SHOWSOUNDS = 70,
            SM_CXMENUCHECK = 71,
            SM_CYMENUCHECK = 72,
            SM_SLOWMACHINE = 73,
            SM_MIDEASTENABLED = 74,
            SM_MOUSEPRESENT = 19,
            SM_XVIRTUALSCREEN = 76,
            SM_YVIRTUALSCREEN = 77,
            SM_CXVIRTUALSCREEN = 78,
            SM_CYVIRTUALSCREEN = 79,
            SM_CMONITORS = 80,
            SM_SAMEDISPLAYFORMAT = 81,
            SM_IMMENABLED = 82,
            SM_CXFOCUSBORDER = 83,
            SM_CYFOCUSBORDER = 84,
            SM_TABLETPC = 86,
            SM_MEDIACENTER = 87,
            SM_CMETRICS_OTHER = 76,
            SM_CMETRICS_2000 = 83,
            SM_CMETRICS_NT = 88,
            SM_REMOTESESSION = 0x1000,
            SM_SHUTTINGDOWN = 0x2000,
            SM_REMOTECONTROL = 0x2001,
        }

        [DllImport("user32.dll")]
        internal static extern bool SetWindowPos(IntPtr hWnd, IntPtr hWndInsertAfter, int X, int Y, int cx, int cy, uint uFlags);

        internal const uint SWP_NOSIZE          = 0x0001;
        internal const uint SWP_NOMOVE          = 0x0002;
        internal const uint SWP_NOZORDER        = 0x0004;
        internal const uint SWP_NOREDRAW        = 0x0008;
        internal const uint SWP_NOACTIVATE      = 0x0010;
        internal const uint SWP_FRAMECHANGED    = 0x0020;
        internal const uint SWP_SHOWWINDOW      = 0x0040;
        internal const uint SWP_HIDEWINDOW      = 0x0080;
        internal const uint SWP_NOCOPYBITS      = 0x0100;
        internal const uint SWP_NOOWNERZORDER   = 0x0200;
        internal const uint SWP_NOSENDCHANGING  = 0x0400;
        internal const uint SWP_DRAWFRAME       = 0x0020;
        internal const uint SWP_NOREPOSITION    = 0x0200;
        internal const uint SWP_DEFERERASE      = 0x2000;
        internal const uint SWP_ASYNCWINDOWPOS  = 0x4000;

        internal static readonly IntPtr HWND_TOP        = (IntPtr)(0);
        internal static readonly IntPtr HWND_BOTTOM     = (IntPtr)(1);
        internal static readonly IntPtr HWND_TOPMOST    = (IntPtr)(-1);
        internal static readonly IntPtr HWND_NOTOPMOST  = (IntPtr)(-2);

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        internal static extern int GetScrollInfo (IntPtr hWnd, int fnBar, ref SCROLLINFO info);

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        internal static extern int SetScrollInfo(IntPtr hwnd, int bar, ref SCROLLINFO si, int fRedraw);

        [StructLayout(LayoutKind.Sequential)]
        internal struct SCROLLINFO
        {
            public uint cbSize;
            public uint fMask;
            public int nMin;
            public int nMax;
            public uint nPage;
            public int nPos;
            public int nTrackPos;
        }
        internal enum ScrollBarDirection
        {
            SB_HORZ = 0,
            SB_VERT = 1,
            SB_CTL = 2,
            SB_BOTH = 3
        }
        internal enum ScrollInfoMask
        {
            SIF_RANGE = 0x1,
            SIF_PAGE = 0x2,
            SIF_POS = 0x4,
            SIF_DISABLENOSCROLL = 0x8,
            SIF_TRACKPOS = 0x10,
            SIF_ALL = SIF_RANGE + SIF_PAGE + SIF_POS + SIF_TRACKPOS
        }

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        internal static extern IntPtr SetParent(IntPtr hWndChild, IntPtr hWndNewParent);

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        internal static extern long ShowScrollBar (IntPtr hwnd, ScrollBarDirection wBar, long bShow);

        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        internal static extern IntPtr GetActiveWindow();

        // gdi32.dll
        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool BitBlt(IntPtr hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, IntPtr hdcSrc, int nXSrc, int nYSrc, int dwRop);

        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern int CombineRgn(IntPtr hrgnDst, IntPtr hrgnSrc1, IntPtr hrgnSrc2, int fnCombineMode);

        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern IntPtr CreateRectRgn(int x1, int y1, int x2, int y2);

        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        internal static extern bool DeleteObject(IntPtr hObject);

        internal const byte PFD_TYPE_RGBA = 0;
        internal const byte PFD_TYPE_COLORINDEX = 1;

        internal const byte PFD_MAIN_PLANE = 0;
        internal const byte PFD_OVERLAY_PLANE = 1;
        internal const byte PFD_UNDERLAY_PLANE = unchecked((byte)-1);

        internal const uint PFD_DOUBLEBUFFER = 1;
        internal const uint PFD_STEREO = 2;
        internal const uint PFD_DRAW_TO_WINDOW = 4;
        internal const uint PFD_DRAW_TO_BITMAP = 8;
        internal const uint PFD_SUPPORT_GDI = 16;
        internal const uint PFD_SUPPORT_OPENGL = 32;
        internal const uint PFD_GENERIC_FORMAT = 64;
        internal const uint PFD_NEED_PALETTE = 128;
        internal const uint PFD_NEED_SYSTEM_PALETTE = 0x00000100;
        internal const uint PFD_SWAP_EXCHANGE = 0x00000200;
        internal const uint PFD_SWAP_COPY = 0x00000400;
        internal const uint PFD_DOUBLEBUFFER_DONTCARE = 0x40000000;
        internal const uint PFD_STEREO_DONTCARE = 0x80000000;

        [DllImport("gdi32.dll", SetLastError = true)]
        internal static extern int ChoosePixelFormat(IntPtr hdc, [In] ref PIXELFORMATDESCRIPTOR ppfd);

        [DllImport("gdi32.dll", SetLastError = true)]
        internal static extern bool SetPixelFormat(IntPtr hdc, int iPixelFormat, ref PIXELFORMATDESCRIPTOR ppfd);

        // kernel32.dll
        [DllImport("kernel32.dll", CharSet = CharSet.Unicode, SetLastError = true)]
        internal static extern IntPtr LoadLibrary(string lpFileName);

        [DllImport("kernel32.dll", SetLastError = true)]
        internal static extern bool FreeLibrary(IntPtr hModule);

        //CA2101	P/Invoke 文字列引数に対してマーシャリングを指定します	セキュリティ上の問題を軽減するには、DllImport.CharSet を CharSet.Unicode に設定するか、またはパラメーターを明示的に UnmanagedType.LPWStr としてマーシャリングすることで、パラメーター 'lpProcName' を Unicode としてマーシャリングします。この文字列を ANSI またはシステム依存としてマーシャリングする必要がある場合は、MarshalAs を明示的に指定して、BestFitMapping=false と設定し、またセキュリティ強化のために ThrowOnUnmappableChar=true と設定します。
        [DllImport("kernel32.dll", SetLastError = true, ExactSpelling = false, BestFitMapping = false, ThrowOnUnmappableChar = true)]
        internal static extern IntPtr GetProcAddress(IntPtr hModule, [MarshalAs(UnmanagedType.LPStr)] string lpProcName);
//		[DllImport("kernel32.dll", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = false)]
//		internal static extern IntPtr GetProcAddress(IntPtr hModule, string lpProcName);

        [DllImport("kernel32.dll")]
        internal static extern bool GetThreadTimes(IntPtr threadHandle, out long createionTime, out long exitTime, out long kernelTime, out long userTime);

        [DllImport("kernel32.dll")]
        internal static extern IntPtr GetCurrentThread();

        // デスクトップ ウィンドウ マネージャを使用して特殊効果を施す
        // http://msdn.microsoft.com/ja-jp/magazine/cc163435.aspx
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern void DwmEnableBlurBehindWindow(IntPtr hWnd, DWM_BLURBEHIND pBlurBehind);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern void DwmExtendFrameIntoClientArea(IntPtr hWnd, MARGINS pMargins);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern bool DwmIsCompositionEnabled();
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern void DwmEnableComposition(bool bEnable);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern void DwmGetColorizationColor(
            out int pcrColorization,
            [MarshalAs(UnmanagedType.Bool)]out bool pfOpaqueBlend);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern IntPtr DwmRegisterThumbnail(IntPtr dest, IntPtr source);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern void DwmUnregisterThumbnail(IntPtr hThumbnail);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern void DwmUpdateThumbnailProperties(
            IntPtr hThumbnail, DWM_THUMBNAIL_PROPERTIES props);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        public static extern void DwmQueryThumbnailSourceSize(
            IntPtr hThumbnail, out Size size);

        [StructLayout(LayoutKind.Sequential)]
        public class DWM_THUMBNAIL_PROPERTIES
        {
            public uint dwFlags;
            public RECT rcDestination;
            public RECT rcSource;
            public byte opacity;
            [MarshalAs(UnmanagedType.Bool)]
            public bool fVisible;
            [MarshalAs(UnmanagedType.Bool)]
            public bool fSourceClientAreaOnly;
            public const uint DWM_TNP_RECTDESTINATION = 0x00000001;
            public const uint DWM_TNP_RECTSOURCE = 0x00000002;
            public const uint DWM_TNP_OPACITY = 0x00000004;
            public const uint DWM_TNP_VISIBLE = 0x00000008;
            public const uint DWM_TNP_SOURCECLIENTAREAONLY = 0x00000010;
        }

        [StructLayout(LayoutKind.Sequential)]
        public class MARGINS
        {
            public int cxLeftWidth, cxRightWidth,
                       cyTopHeight, cyBottomHeight;
            public MARGINS(int left, int top, int right, int bottom)
            {
                cxLeftWidth = left; cyTopHeight = top;
                cxRightWidth = right; cyBottomHeight = bottom;
            }
        }

        [StructLayout(LayoutKind.Sequential)]
        public class DWM_BLURBEHIND
        {
            public uint dwFlags;
            [MarshalAs(UnmanagedType.Bool)]
            public bool fEnable;
            public IntPtr hRegionBlur;
            [MarshalAs(UnmanagedType.Bool)]
            public bool fTransitionOnMaximized;

            public const uint DWM_BB_ENABLE = 0x00000001;
            public const uint DWM_BB_BLURREGION = 0x00000002;
            public const uint DWM_BB_TRANSITIONONMAXIMIZED = 0x00000004;
        }

        [DllImport("kernel32.dll")]
        public static extern IntPtr GetCurrentProcess();

        [DllImport("user32.dll")]
        public static extern uint GetGuiResources(IntPtr hProcess, uint uiFlags);

        public enum ResourceType
        {
            Gdi = 0,
            User = 1
        }

        [DllImport("User32.dll", CharSet=CharSet.Auto)]
        internal static extern IntPtr GetSystemMenu ( IntPtr hWnd, int bRevert );

        [DllImport("User32.dll", CharSet=CharSet.Auto)]
        internal static extern int GetMenuItemCount(IntPtr hMenu);

        [DllImport("User32.dll", CharSet=CharSet.Auto)]
        internal static extern int DrawMenuBar(IntPtr hWnd);

        [DllImport("User32.dll", CharSet=CharSet.Auto)]
        internal static extern int RemoveMenu(IntPtr hMenu, int nPosition, int wFlags);

        internal const int MF_BYPOSITION = 0x400;

        [DllImport("user32.dll")]
        internal static extern uint keybd_event(byte bVk, byte bScan, uint dwFlags, UIntPtr dwExtraInfo);

        internal const uint KEYEVENTF_KEYUP = 2;


        internal const int EM_GETSCROLLPOS = 0x04DD;
        internal const int EM_SETSCROLLPOS = 0x04DE;

        [DllImport("shell32.dll", SetLastError=true)]
        public static extern IntPtr CommandLineToArgvW([MarshalAs(UnmanagedType.LPWStr)]string lpCmdLine, out int pNumArgs);

        [DllImport("user32.dll")]
        public static extern IntPtr GetCapture();

        [InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("00000002-0000-0000-C000-000000000046")]
        public interface IMalloc
        {
            [PreserveSig]
            IntPtr Alloc([In] int cb);

            [PreserveSig]
            IntPtr Realloc([In] IntPtr pv, [In] int cb);

            [PreserveSig]
            void Free([In] IntPtr pv);

            [PreserveSig]
            int GetSize([In] IntPtr pv);

            [PreserveSig]
            int DidAlloc(IntPtr pv);

            [PreserveSig]
            void HeapMinimize();
        }

        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        public delegate int BFFCALLBACK(IntPtr hwnd, uint uMsg, IntPtr lParam, IntPtr lpData);

        [StructLayout(LayoutKind.Sequential, Pack = 8)]
        public struct BROWSEINFO
        {
            public IntPtr hwndOwner;
            public IntPtr pidlRoot;
            public IntPtr pszDisplayName;
            [MarshalAs(UnmanagedType.LPTStr)]
            public string lpszTitle;
            public int ulFlags;
            [MarshalAs(UnmanagedType.FunctionPtr)]
            public BFFCALLBACK lpfn;
            public IntPtr lParam;
            public int iImage;
        }

        [DllImport("shell32.dll", CharSet = CharSet.Auto)]
        public static extern int SHGetMalloc(out IMalloc ppMalloc);

        [DllImport("shell32.dll", CharSet = CharSet.Auto)]
        public static extern int SHGetSpecialFolderLocation(IntPtr hwndOwner, int nFolder, out IntPtr ppidl);

        [DllImport("shell32.dll", CharSet = CharSet.Auto)]
        public static extern int SHGetPathFromIDList(IntPtr pidl, System.Text.StringBuilder pszPath);

        [DllImport("shell32.dll", CharSet = CharSet.Auto)]
        public static extern IntPtr SHBrowseForFolder(ref BROWSEINFO lpbi);

        [DllImport("shlwapi.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern bool PathCanonicalize([Out] System.Text.StringBuilder lpszDst, string lpszSrc);

        internal const uint GL_NO_ERROR = 0;
        internal const uint GL_MAJOR_VERSION = 0x821B;
        internal const uint GL_MINOR_VERSION = 0x821C;
        internal const uint GL_SHADING_LANGUAGE_VERSION = 0x8B8C;

        // opengl32.dll
        [DllImport("opengl32.dll")]
        internal static extern uint glGetError();

        [DllImport("opengl32.dll")]
        internal unsafe static extern sbyte* glGetString(uint name);

        [DllImport("opengl32.dll")]
        internal static extern void glGetIntegerv(uint pname, [Out, MarshalAs(UnmanagedType.LPArray)] int[] parameters);

        public const int WGL_CONTEXT_MAJOR_VERSION_ARB = 0x2091;
        public const int WGL_CONTEXT_MINOR_VERSION_ARB = 0x2092;
        public const int WGL_CONTEXT_PROFILE_MASK_ARB = 0x9126;
        public const int WGL_CONTEXT_CORE_PROFILE_BIT_ARB = 0x00000001;
        public const int WGL_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB = 0x00000002;

        [DllImport("opengl32.dll", SetLastError = true)]
        public static extern IntPtr wglCreateContext(IntPtr hdc);

        [DllImport("opengl32.dll", SetLastError = true)]
        public static extern bool wglDeleteContext(IntPtr hglrc);

        [DllImport("opengl32.dll", SetLastError = true)]
        public static extern bool wglMakeCurrent(IntPtr hdc, IntPtr hglrc);

        [DllImport("opengl32.dll", SetLastError = true, ExactSpelling = false, BestFitMapping = false, ThrowOnUnmappableChar = true)]
        public static extern IntPtr wglGetProcAddress([MarshalAs(UnmanagedType.LPStr)] string lpszProc);
    }
}
