﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;

namespace App.Utility
{
    /// <summary>
    /// 待機カーソルクラス。
    /// </summary>
    public sealed class WaitCursor : IDisposable
    {
        // カレントカーソル
        private readonly Cursor _cursor = Cursor.Current;

        // count > 0 && barrierCount == 0 のときのみ待機カーソルを表示
        public static int count = 0;
        public static int barrierCount = 0;

        private bool _wait;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public WaitCursor(bool wait=true)
        {
            _wait = wait;

            if (_wait)
            {
                // 待機カーソルに変更
                if (barrierCount == 0 && count == 0)
                {
                    StartWait();
                }

                count++;
            }
            else
            {
                // カーソルを元に戻す
                if (barrierCount == 0 && count > 0)
                {
                    EndWait();
                }
                barrierCount++;
            }
        }

        #region IDisposable実装
        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public void Dispose()
        {
            if (_wait)
            {
                count--;

                // カーソルを元に戻す
                if (barrierCount == 0 && count == 0)
                {
                    EndWait();
                }
            }
            else
            {
                barrierCount--;

                // 待機カーソルに変更
                if (barrierCount == 0 && count > 0)
                {
                    StartWait();
                }
            }
        }
        #endregion

        private Cursor previous;
        private void StartWait()
        {
            // ちなみに、Application.UseWaitCursor だとすぐに反映されなかったり、
            // 非表示のコントロールに適用されなかったりする。
            previous = Cursor.Current;
            Cursor.Current = Cursors.WaitCursor;
        }

        private void EndWait()
        {
            Cursor.Current = previous;
        }
    }
}
