﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace App.Utility
{
    public sealed class SuppressBlock : IDisposable
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SuppressBlock(SuppressBlockCounter counter)
        {
            this.counter = counter;
            this.counter.CountUp();
        }

        /// <summary>
        /// 解放処理
        /// </summary>
        public void Dispose()
        {
            counter.CountDown();
        }

        private readonly SuppressBlockCounter counter;
    }

    /// <summary>
    /// ブロックのカウンタ
    /// </summary>
    public class SuppressBlockCounter
    {
        private int count = 0;

        public bool CheckBlock
        {
            get {
                if (count > 0)
                {
                    // 解放時にイベントを実行するようにする。
                    Blocked = true;
                }

                return count > 0;
            }
        }

        private bool Blocked = false;
        public event Action ReleasedEvent;
        public void CountUp() { count++; }
        public void CountDown()
        {
            Debug.Assert(count > 0);
            count--;
            if (count == 0)
            {
                if (ReleasedEvent != null && Blocked)
                {
                    ReleasedEvent();
                }

                Blocked = false;
            }
        }
    }
}
