﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;

namespace App.Utility
{
    public static class ShaderOptionUtility
    {
        public enum OptionType {
            Bool,
            Int,
            Enum,
        }

        static public OptionType Type(string choice)
        {
            if (choice == "bool")
            {
                return OptionType.Bool;
            }

            int min, max;
            if (IfShaderAssignUtility.TryParseIntRange(choice, out min, out max))
            {
                return OptionType.Int;
            }
            return OptionType.Enum;
        }

        public class OptionsComparer : IEqualityComparer<List<shader_optionType>>
        {
            bool IEqualityComparer<List<shader_optionType>>.Equals(List<shader_optionType> x, List<shader_optionType> y)
            {
                return x.Count == y.Count && x.Zip(y, (u, v) => u.id == v.id && u.value == v.value).All(w => w);
            }

            int IEqualityComparer<List<shader_optionType>>.GetHashCode(List<shader_optionType> x)
            {
                int code = 0;
                foreach (var item in x)
                {
                    code = ShaderTypeUtility.MixHash(code, item.id);
                    code = ShaderTypeUtility.MixHash(code, item.value);
                }
                return code;
            }
        }
    }
}
