﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

namespace App.Utility
{
    /// <summary>
    /// コンストラクタされてからDispose されるまでの時間を MessageLog に出力します。
    /// </summary>
    public class MessageLogStopWatch
    {
        private Stopwatch Stopwatch { get; set; }
        private string message { get; set; }
        public MessageLogStopWatch(string message, bool output)
        {
            if (output)
            {
                Stopwatch = new Stopwatch();
                Stopwatch.Start();
                this.message = message;
            }
        }

        public void WriteLog()
        {
            if (Stopwatch != null)
            {
                message += string.Format(": {0} ms", Stopwatch.ElapsedMilliseconds);
                MessageLog.Write(MessageLog.LogType.Information, message);
                Stopwatch = null;
            }
        }
    }

}
