﻿using App.Controls;
using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace App.Utility
{
    public static class HelpUtility
    {
        public static void Open(PageKey key)
        {
            try
            {
                var splitted = KeyToUrl[(int)key].Split('#');
                var path = Path.Combine(
                    Environment.GetEnvironmentVariable("NW4F_3DEDITOR_ROOT"),
                    @"..\..\..\Documents\Package\contents\Pages\",
                    splitted[0]);

                path = Path.GetFullPath(path);

                // ファイルがないときはエラー
                if (!File.Exists(path))
                {
                    UIMessageBox.Error(res.Strings.Help_FileNotExist, path);
                    return;
                }

                if (splitted.Length == 2)
                {
                    path += "#" + splitted[1];
                }

                // exe を指定しないとアンカーが扱えない
                var exe = GetDefaultBrowserExePath();

                // file:/// がないと FireFox で正しく開けない
                var arg = string.Format("file:///{0}", path.Replace("\\", "/"));

                // InternetExplorer 以外の場合は引数をエスケープする
                if (!exe.ToLower().Contains("iexplore"))
                {
                    arg = Uri.EscapeUriString(arg);
                }

                DebugConsole.Write(exe + " " + arg);

                if (string.IsNullOrEmpty(exe))
                {
                    Debug.Assert(false);
                    Process.Start(arg);
                }
                else
                {
                    Process.Start(exe, arg);
                }
            }
            catch (Exception e)
            {
                UIMessageBox.Error(e.Message);
            }
        }

        // EffectMaker からコピー
        /// <summary>
        /// 任意の既定アプリケーションのファイルパスを取得します.
        /// </summary>
        /// <returns>規定のアプリケーションファイルパス</returns>
        private static string GetDefaultBrowserExePath()
        {
            // http://stackoverflow.com/a/17599201
            const string userChoice = @"Software\Microsoft\Windows\Shell\Associations\UrlAssociations\http\UserChoice";
            try
            {
                using (var key = Registry.CurrentUser.OpenSubKey(userChoice))
                {
                    if (key != null)
                    {
                        var progIdValue = key.GetValue("ProgId");
                        if (progIdValue != null)
                        {
                            using (var pathKey = Registry.ClassesRoot.OpenSubKey(progIdValue.ToString() + @"\shell\open\command"))
                            {
                                if (pathKey != null)
                                {
                                    var command = pathKey.GetValue(null).ToString();

                                    // 引数がついているかもしれないのでコマンド部分だけ取得
                                    int argc;
                                    var argv = Win32.NativeMethods.CommandLineToArgvW(command, out argc);
                                    if (argv != IntPtr.Zero)
                                    {
                                        try
                                        {
                                            // 0 番目の文字列を取得
                                            var arg = Marshal.ReadIntPtr(argv, 0);
                                            return Marshal.PtrToStringUni(arg);
                                        }
                                        finally
                                        {
                                            Marshal.FreeHGlobal(argv);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch
            {
            }

            return string.Empty;
        }

        // TODO: 未対応のページ
        // SkeletalAnimationPreviewPage
        // EditLabelDialog
        // SearchPathPage
        // UserCommandDialog 非公開?
        // ヘルプを開くためのコードの追加: http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=100920468&moved=true

        public enum PageKey
        {
            p_help_news,
            p_animation_property_window_pattern_page,
            p_animation_property_window_pattern_page_a_tex_pattern_add,
            p_animation_property_window_pattern_page_a_tex_pattern_change,
            p_material_property_window_original_information_page,
            p_file_view,
            p_file_view_a_read_tga,
            p_file_view_a_right_click_menu,
            p_file_view_a_project,
            p_file_view_a_scene_group,
            p_file_view_a_anim_set_scene,
            p_file_view_a_scene_file,
            p_file_view_a_model_group,
            p_file_view_a_anim_set_menu,
            p_file_view_a_model_file,
            p_file_view_a_animation_group,
            p_file_view_a_animation_file,
            p_file_view_a_model_bind_animation,
            p_file_view_a_scene_anim_file,
            p_file_view_a_texture_group,
            p_file_view_a_texture_file,
            p_file_view_a_shader_group,
            p_file_view_a_shader_file,
            p_file_view_a_new_anim,
            p_file_view_a_animation_set,
            p_file_view_a_new_anim_set,
            p_shape_property_window,
            p_shape_property_window_general_page,
            p_bone_property_window,
            p_bone_property_window_general_page,
            p_bone_property_window_general_page_a_bone_information,
            p_bone_property_window_general_page_a_bone_matrix,
            p_bone_property_window_general_page_a_bone_billboard,
            p_model_property_window_lod_model_page,
            p_model_property_window_additional_reference_path_page,
            p_model_property_window_optiomization_log_page,
            p_material_property_window_shader_page,
            p_material_property_window_shader_page_a_shader_pram_id,
            p_material_property_window_shader_page_a_original_label,
            p_material_property_window_shader_page_a_VectorToColorControl,
            p_material_property_window_shader_page_a_slider_cnt,
            p_material_property_window_shader_page_a_jump_button,
            p_material_property_window_shader_page_a_tex_sign_up,
            p_shader_definition_property_window,
            p_animation_property_window_original_information_page,
            p_shape_property_window_bounding_page,
            p_material_property_window,
            p_material_property_window_a_export_dialog,
            p_material_property_window_a_import_dialog,
            p_material_property_window_a_allocation,
            p_shape_property_window_vertex_page,
            p_shape_property_window_mesh_page,
            p_shader_definition_property_window_shader_definition_page,
            p_shader_definition_property_window_source_code_page,
            p_shader_definition_property_window_source_code_page_a_source_code_edit,
            p_shader_definition_property_window_shading_model_page,
            p_toolbar,
            p_model_property_window,
            p_model_property_window_general_page,
            p_model_property_window_preview_page,
            p_project_property_window,
            p_project_property_window_a_file_data,
            p_material_property_window_general_page,
            p_main_window,
            p_main_window_a_obj_switch,
            p_main_menu,
            p_file_menu,
            p_file_menu_a_new_sub_menu,
            p_file_menu_a_open_tga_file,
            p_file_menu_a_change_file,
            p_file_menu_a_file_close_select,
            p_file_menu_a_specified_save,
            p_file_menu_a_material_modification,
            p_file_menu_a_mergedialog,
            p_property_window,
            p_animation_property_window,
            p_animation_property_window_a_special_anim,
            p_animation_property_window_general_page,
            p_animation_property_window_general_page_a_dcc_tools,
            p_overview,
            p_material_property_window_preview_page,
            p_texture_property_window_usage_page,
            p_3deditor,
            p_texture_property_window_general_page,
            p_texture_property_window_general_page_a_display_depth,
            p_texture_property_window_general_page_a_gamma_compensation,
            p_texture_property_window_general_page_a_tex_depth,
            p_texture_property_window_general_page_a_tex_mipmap,
            p_texture_property_window_general_page_a_detail,
            p_texture_property_window,
            p_curve_editor,
            p_curve_editor_a_bone_visibility,
            p_material_property_window_sampler_page,
            p_property_window_common_page,
            p_property_window_common_page_a_file_infomation,
            p_property_window_common_page_a_user_data,
            p_editing_menu,
            p_display_menu,
            p_display_menu_a_view_sub_menu,
            p_display_menu_a_view_list_sub,
            p_display_menu_a_view_list_dialog,
            p_preview_menu,
            p_tools_menu,
            p_tools_menu_a_team_config,
            p_tools_menu_a_user_config,
            p_tools_menu_a_user_config_addpath,
            p_tools_menu_a_edit_log,
            p_tools_menu_a_external_program,
            p_tools_menu_a_IO_config,
            p_tools_menu_a_auto_anim_bind,
            p_tools_menu_a_debug_log_window,
            p_help_menu,
            p_appendices_troubleshooting,
        }

        static string[] KeyToUrl = new string[]
        {
            "Page_113826765.html",
            "Page_83955517.html",
            "Page_83955517.html#Anchor_83955517_tex_pattern_add",
            "Page_83955517.html#Anchor_83955517_tex_pattern_change",
            "Page_83955521.html",
            "Page_83955530.html",
            "Page_83955530.html#Anchor_83955530_read_tga",
            "Page_83955530.html#Anchor_83955530_right_click_menu",
            "Page_83955530.html#Anchor_83955530_project",
            "Page_83955530.html#Anchor_83955530_scene_group",
            "Page_83955530.html#Anchor_83955530_anim_set_scene",
            "Page_83955530.html#Anchor_83955530_scene_file",
            "Page_83955530.html#Anchor_83955530_model_group",
            "Page_83955530.html#Anchor_83955530_anim_set_menu",
            "Page_83955530.html#Anchor_83955530_model_file",
            "Page_83955530.html#Anchor_83955530_animation_group",
            "Page_83955530.html#Anchor_83955530_animation_file",
            "Page_83955530.html#Anchor_83955530_model_bind_animation",
            "Page_83955530.html#Anchor_83955530_scene_anim_file",
            "Page_83955530.html#Anchor_83955530_texture_group",
            "Page_83955530.html#Anchor_83955530_texture_file",
            "Page_83955530.html#Anchor_83955530_shader_group",
            "Page_83955530.html#Anchor_83955530_shader_file",
            "Page_83955530.html#Anchor_83955530_new_anim",
            "Page_83955530.html#Anchor_83955530_animation_set",
            "Page_83955530.html#Anchor_83955530_new_anim_set",
            "Page_83955533.html",
            "Page_83955535.html",
            "Page_83955567.html",
            "Page_83955571.html",
            "Page_83955571.html#Anchor_83955571_bone_information",
            "Page_83955571.html#Anchor_83955571_bone_matrix",
            "Page_83955571.html#Anchor_83955571_bone_billboard",
            "Page_83955582.html",
            "Page_83955586.html",
            "Page_83955588.html",
            "Page_83955594.html",
            "Page_83955594.html#Anchor_83955594_shader_pram_id",
            "Page_83955594.html#Anchor_83955594_original_label",
            "Page_83955594.html#Anchor_83955594_VectorToColorControl",
            "Page_83955594.html#Anchor_83955594_slider_cnt",
            "Page_83955594.html#Anchor_83955594_jump_button",
            "Page_83955594.html#Anchor_83955594_tex_sign_up",
            "Page_83955598.html",
            "Page_83955601.html",
            "Page_83955603.html",
            "Page_83955604.html",
            "Page_83955604.html#Anchor_83955604_export_dialog",
            "Page_83955604.html#Anchor_83955604_import_dialog",
            "Page_83955604.html#Anchor_83955604_allocation",
            "Page_83955607.html",
            "Page_83955608.html",
            "Page_83955625.html",
            "Page_83955627.html",
            "Page_83955627.html#Anchor_83955627_source_code_edit",
            "Page_83955631.html",
            "Page_83955663.html",
            "Page_83955773.html",
            "Page_83955779.html",
            "Page_83955787.html",
            "Page_83955832.html",
            "Page_83955832.html#Anchor_83955832_file_data",
            "Page_83955846.html",
            "Page_83955890.html",
            "Page_83955890.html#Anchor_83955890_obj_switch",
            "Page_83955900.html",
            "Page_83955901.html",
            "Page_83955901.html#Anchor_83955901_new_sub_menu",
            "Page_83955901.html#Anchor_83955901_open_tga_file",
            "Page_83955901.html#Anchor_83955901_change_file",
            "Page_83955901.html#Anchor_83955901_file_close_select",
            "Page_83955901.html#Anchor_83955901_specified_save",
            "Page_83955901.html#Anchor_83955901_material_modification",
            "Page_83955901.html#Anchor_83955901_mergedialog",
            "Page_83955919.html",
            "Page_83955933.html",
            "Page_83955933.html#Anchor_83955933_special_anim",
            "Page_83955941.html",
            "Page_83955941.html#Anchor_83955941_dcc_tools",
            "Page_83955945.html",
            "Page_83955948.html",
            "Page_83955949.html",
            "Page_83955978.html",
            "Page_83955984.html",
            "Page_83955984.html#Anchor_83955984_display_depth",
            "Page_83955984.html#Anchor_83955984_gamma_compensation",
            "Page_83955984.html#Anchor_83955984_tex_depth",
            "Page_83955984.html#Anchor_83955984_tex_mipmap",
            "Page_83955984.html#Anchor_83955984_detail",
            "Page_83955987.html",
            "Page_83956046.html",
            "Page_83956046.html#Anchor_83956046_bone_visibility",
            "Page_83956088.html",
            "Page_83956101.html",
            "Page_83956101.html#Anchor_83956101_file_infomation",
            "Page_83956101.html#Anchor_83956101_user_data",
            "Page_83956251.html",
            "Page_83956252.html",
            "Page_83956252.html#Anchor_83956252_view_sub_menu",
            "Page_83956252.html#Anchor_83956252_view_list_sub",
            "Page_83956252.html#Anchor_83956252_view_list_dialog",
            "Page_83956256.html",
            "Page_83956258.html",
            "Page_83956258.html#Anchor_83956258_team_config",
            "Page_83956258.html#Anchor_83956258_user_config",
            "Page_83956258.html#Anchor_83956258_user_config_addpath",
            "Page_83956258.html#Anchor_83956258_edit_log",
            "Page_83956258.html#Anchor_83956258_external_program",
            "Page_83956258.html#Anchor_83956258_IO_config",
            "Page_83956258.html#Anchor_83956258_auto_anim_bind",
            "Page_83956258.html#Anchor_83956258_debug_log_window",
            "Page_83956259.html",
            "Page_83956140.html",
        };
    }
}
