﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace App.Utility
{
    class GraphicsInterpolationModeBlock : IDisposable
    {
        private readonly Graphics			graphics_;
        private readonly InterpolationMode	interpolationMode_;

        public GraphicsInterpolationModeBlock(Graphics graphics, InterpolationMode? mode = null)
        {
            graphics_			= graphics;
            interpolationMode_	= graphics_.InterpolationMode;

            if (mode != null)
            {
                graphics_.InterpolationMode = (InterpolationMode)mode;
            }
        }

        public void Dispose()
        {
            graphics_.InterpolationMode = interpolationMode_;
        }
    }

    class GraphicsSmoothingModeBlock : IDisposable
    {
        private readonly Graphics		graphics_;
        private readonly SmoothingMode	smoothingMode_;

        public GraphicsSmoothingModeBlock(Graphics graphics, SmoothingMode? mode = null)
        {
            graphics_		= graphics;
            smoothingMode_	= graphics_.SmoothingMode;

            if (mode != null)
            {
                graphics_.SmoothingMode = (SmoothingMode)mode;
            }
        }

        public void Dispose()
        {
            graphics_.SmoothingMode = smoothingMode_;
        }
    }
}
