﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace App.Utility
{
    /// <summary>
    /// コンストラクタされてからDispose されるまでの時間をDebugConsole に出力します。
    /// thread 時間はコンストラクトとDispose が同一スレッド上で実行されたときのみ有効です。
    /// </summary>
    public sealed class DebugStopWatch : IDisposable
    {
#if DEBUG
        // スレッドの経過時間(100ns 単位)
        public static long GetThreadTime()
        {
            long creationTime;
            long exitTime;
            long kernelTime;
            long userTime;
            App.Win32.NativeMethods.GetThreadTimes(App.Win32.NativeMethods.GetCurrentThread(), out creationTime, out exitTime, out kernelTime, out userTime);
            return kernelTime + userTime;
        }

        public Stopwatch Stopwatch { get; set; }

        public long startThreadTime;
        public bool output { get; set; }
        private string message { get; set; }
#endif

        [Conditional("DEBUG")]
        public void SetMessage(string m)
        {
#if DEBUG
            message = m;
#endif
        }

        public DebugStopWatch(string message)
        {
#if DEBUG
            this.message = message;
            Stopwatch = new Stopwatch();
            Stopwatch.Start();
            startThreadTime = GetThreadTime();
            output = true;
#endif
        }

        public void Dispose()
        {
#if DEBUG
            long threadTime = (GetThreadTime() - startThreadTime)/10000; // 100 ns/ 1 ms
            Stopwatch.Stop();
            if (output)
            {
                DebugConsole.WriteLine(string.Format("{0} : {1} ms (thread {2} ms)", message, Stopwatch.ElapsedMilliseconds, threadTime));
            }
#endif
        }
    }
}
