﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Threading;
using System.Diagnostics;
using System;

namespace App.Utility
{
    public static class BitmapUtility
    {
        private const int timeoutCount = 10;

        public static void DrawTextureImage(Graphics graphics, Bitmap textureImage, int width, int height, bool is1D, int top = 1, int left = 1)
        {
            // TODO:他のスレッドで使用中だと 例外が起きる
            // ビットマップのインスタンスはスレッドセーフではない!
            for(int i = 0;i != timeoutCount;++ i)
            {
                try
                {
                    DrawTextureImageInternal(graphics, textureImage, textureImage.Width, textureImage.Height, 0, 0, width, height, is1D, top, left);
                    break;
                }
                catch (Exception e)
                {
                    Debug.Assert(false, e.Message);
                    Thread.Sleep(1 + i);
                }
            }
        }

        public static void DrawTextureSubImage(Graphics graphics, Bitmap textureImage, int srcWidth, int srcHeight, int srcLeft, int srcTop, int width, int height, bool is1D, int top = 1, int left = 1)
        {
            // TODO:他のスレッドで使用中だと 例外が起きる
            // ビットマップのインスタンスはスレッドセーフではない!
            for (int i = 0; i != timeoutCount; ++i)
            {
                try
                {
                    DrawTextureImageInternal(graphics, textureImage, srcWidth, srcHeight, srcLeft, srcTop, width, height, is1D, top, left);
                    break;
                }
                catch (Exception e)
                {
                    Debug.Assert(false, e.Message);
                    Thread.Sleep(1 + i);
                }
            }
        }

        private static void DrawTextureImageInternal(Graphics graphics, Bitmap textureImage, int srcWidth, int srcHeight, int srcLeft, int srcTop, int width, int height, bool is1D, int top, int left)
        {
            using(var sb = new GraphicsSmoothingModeBlock(graphics, SmoothingMode.HighQuality))
            {
                if (textureImage != null)
                {
                    var rect = new Rectangle(left, top, width - 2, height - 2);

                    // 描画領域
                    // 領域が極端に小さい場合は縦横比の補正をしない
                    var rcDraw = rect;
                    if ((is1D == false) && (!(rcDraw.Width < 16 || rcDraw.Height < 16)))
                    {
                        // 横長（高さを縮小）
                        if (srcWidth > srcHeight)
                        {
                            rcDraw.Height = (int)(rect.Height * (float)srcHeight / (float)srcWidth);
                        }
                        // 縦長（幅を縮小）
                        else if (srcHeight > srcWidth)
                        {
                            rcDraw.Width = (int)(rect.Width * (float)srcWidth / (float)srcHeight);
                        }
                    }

                    using(var ib = new GraphicsInterpolationModeBlock(graphics))
                    {
                        var ptSampling = new PointF(srcLeft, srcTop);
                        {
                            // 拡大時はポイントサンプリング
                            if (rcDraw.Width >= srcWidth || rcDraw.Height >= srcHeight)
                            {
                                graphics.InterpolationMode = InterpolationMode.NearestNeighbor;

                                // 起点を半ピクセルずらす
                                ptSampling.X -= 0.5f;
                                ptSampling.Y -= 0.5f;
                            }
                            // 縮小時は規定の補間モード
                            else
                            {
                                graphics.InterpolationMode = InterpolationMode.Default;
                            }
                        }

                        graphics.DrawImage(textureImage, rcDraw, ptSampling.X, ptSampling.Y, srcWidth, srcHeight, GraphicsUnit.Pixel);
                    }
                }
                else
                {
                    var rcImage = new Rectangle(left-1, top-1, width - 1, height - 1);
                    rcImage.Inflate(-2, -2);

                    var pen = SystemPens.ControlDark;

                    graphics.DrawRectangle(pen, rcImage);
                    graphics.DrawLine(pen, RectangleUtility.GetTopLeft(rcImage), RectangleUtility.GetBottomRight(rcImage));
                    graphics.DrawLine(pen, RectangleUtility.GetBottomLeft(rcImage), RectangleUtility.GetTopRight(rcImage));
                }
            }
        }
    }
}
