﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Drawing.Imaging;

namespace App.Utility
{
    /// <summary>
    /// ビットマップ加工処理クラス。
    /// </summary>
    public sealed class BitmapProcess : IDisposable
    {
        // ビットマップ
        private readonly Bitmap _bitmap;
        // ビットマップデータ
        private readonly BitmapData _bitmapData;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public BitmapProcess(Bitmap bitmap)
        {
            _bitmap = bitmap;

            // ロック開始
            _bitmapData = bitmap.LockBits(new Rectangle(0, 0, bitmap.Width, bitmap.Height), ImageLockMode.ReadWrite, bitmap.PixelFormat);
        }

        /// <summary>
        /// ビットマップデータ。
        /// </summary>
        public BitmapData BitmapData
        {
            get { return _bitmapData; }
        }

        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public void Dispose()
        {
            // ロック解除
            _bitmap.UnlockBits(_bitmapData);
        }
    }
}
