﻿using App.Data;
using App.res;
using System.Linq;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class TexturePatternAnimationPanel : AnimationObjectPropertyPanel, IHasTexturePatternCurvePage
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TexturePatternAnimationPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_TexturePatternAnimation_Root, PropertyPageID.TexturePatternAnimationRoot, TexturePatternAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_TexturePatternAnimation_General, PropertyPageID.TexturePatternAnimationGeneral, TexturePatternAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => TexturePatternAnimationGeneralPage.IsModified(ActiveTarget));
            var ctgPattern = RegisterCategory(1, Strings.ObjectPropertyPanel_TexturePatternAnimation_Pattern, PropertyPageID.TexturePatternAnimationPattern, TexturePatternAnimationPatternPage.CreateInstance,
                    updateModifiedFunc: () => TexturePatternAnimationPatternPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_TexturePatternAnimation_CurveEdit, PropertyPageID.TexturePatternAnimationCurveEdit, TexturePatternAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                    updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgSearchPath = RegisterCategory(1, Strings.ObjectPropertyPanel_Model_SearchPath, PropertyPageID.ModelSearchPath, SearchPathPage.CreateInstance,
                    updateModifiedFunc: () => SearchPathPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgPattern);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgSearchPath);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private TexturePatternAnimation ActiveTarget
        {
            get { return (TexturePatternAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgCurveEdit;
        }

        public void SelectTexturePatternCurvePage(System.Collections.Generic.IEnumerable<string> materials, string sampler)
        {
            CategoryView.SelectedNode = ctgCurveEdit;
            var curvePage = (TexturePatternAnimationCurveEditPage)ActivePage;
            if (materials != null)
            {
                materials = materials.Where(x => !string.IsNullOrEmpty(x));
                if (materials.Any())
                {
                    curvePage.Select(materials.ToArray(), sampler);
                }
            }
        }

        /// <summary>
        /// フィットする
        /// SelectCurvePage の後で行う
        /// </summary>
        public void FitCurvePage()
        {
            var curvePage = (TexturePatternAnimationCurveEditPage)ActivePage;
            curvePage.FitAfterSelect();
        }
    }

    public interface IHasTexturePatternCurvePage
    {
        void SelectTexturePatternCurvePage(System.Collections.Generic.IEnumerable<string> materials, string sampler);
        void FitCurvePage();
    }

}
