﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using App.Data;
using App.res;
using System.Linq;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class ShaderParameterAnimationPropertyPanel : AnimationObjectPropertyPanel, IHasShaderParameterCurvePage
    {
        private PropertyCategoryNode ctgRoot;
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;
        private PropertyCategoryNode ctgOriginal;
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ShaderParameterAnimationPropertyPanel(ObjectPropertyDialog.PanelID panelID)
        {
            InitializeCategoryView(panelID);

            IsShaderParamAnimGroupCondShowVisible = true;
            IsOnlyTargetShowNodeVisible = true;
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView(ObjectPropertyDialog.PanelID panelID)
        {
            var rootText = panelID == ObjectPropertyDialog.PanelID.ColorAnimation ? Strings.ObjectPropertyPanel_ColorAnimation_Root :
                panelID == ObjectPropertyDialog.PanelID.TextureSrtAnimation ? Strings.ObjectPropertyPanel_TextureSrtAnimation_Root :
                Strings.ObjectPropertyPanel_ShaderParameterAnimation_Root;
            // カテゴリ登録
                ctgRoot = RegisterCategory(0, rootText, PropertyPageID.ShaderParameterAnimationRoot, ShaderParameterAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_ShaderParameterAnimation_General, PropertyPageID.ShaderParameterAnimationGeneral, ShaderParameterAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => ShaderParameterAnimationGeneralPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_ShaderParameterAnimation_CurveEdit, PropertyPageID.ShaderParameterAnimationCurveEdit, ShaderParameterAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
                ctgOriginal = RegisterCategory(1, Strings.ObjectPropertyPanel_ShaderParameterAnimation_Original, PropertyPageID.ShaderParameterAnimationOriginal, ShaderParameterAnimationOriginalInfoPage.CreateInstance);

            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                    updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgOriginal);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private ShaderParameterAnimation ActiveTarget
        {
            get { return (ShaderParameterAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgCurveEdit;
        }

        /// <summary>
        /// カーブページを開きカーブを選択する
        /// </summary>
        public void SelectShaderParameterCurvePage(System.Collections.Generic.IEnumerable<string> materials, string uniform, int? componentIndex)
        {
            CategoryView.SelectedNode = ctgCurveEdit;
            var curvePage = (ShaderParameterAnimationCurveEditPage)ActivePage;
            if (materials != null)
            {
                materials = materials.Where(x => !string.IsNullOrEmpty(x));
                if (materials.Any())
                {
                    curvePage.Select(materials, uniform);
                }
            }
        }

        /// <summary>
        /// フィットする
        /// SelectCurvePage の後で行う
        /// </summary>
        public void FitCurvePage()
        {
            var curvePage = (ShaderParameterAnimationCurveEditPage)ActivePage;
            curvePage.FitAfterSelect();
        }

        private void InitializeComponent()
        {
            ((System.ComponentModel.ISupportInitialize)(spcLeft)).BeginInit();
            spcLeft.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(spcClient)).BeginInit();
            spcClient.Panel1.SuspendLayout();
            spcClient.SuspendLayout();
            SuspendLayout();
            //
            // spcLeft
            //
            spcLeft.Size = new System.Drawing.Size(180, 538);
            //
            // spcClient
            //
            //
            // ShaderParameterAnimationPropertyPanel
            //
            AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            Name = "ShaderParameterAnimationPropertyPanel";
            ((System.ComponentModel.ISupportInitialize)(spcLeft)).EndInit();
            spcLeft.ResumeLayout(false);
            spcClient.Panel1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(spcClient)).EndInit();
            spcClient.ResumeLayout(false);
            ResumeLayout(false);

        }
    }

    public interface IHasShaderParameterCurvePage
    {
        /// <summary>
        /// カーブページを開きカーブを選択する
        /// </summary>
        void SelectShaderParameterCurvePage(System.Collections.Generic.IEnumerable<string> materials, string uniform, int? componentIndex);

        /// <summary>
        /// フィットする
        /// SelectCurvePage の後で行う
        /// </summary>
        void FitCurvePage();
    }
}
