﻿using System.Collections.Generic;
using System.Linq;
using App.Data;
using App.res;
using ConfigCommon;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class FogAnimationPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public FogAnimationPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_FogAnimation_Root, PropertyPageID.FogAnimationRoot, FogAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_FogAnimation_General, PropertyPageID.FogAnimationGeneral, FogAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => FogAnimationGeneralPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_FogAnimation_CurveEdit, PropertyPageID.FogAnimationCurveEdit, FogAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private FogAnimation ActiveTarget
        {
            get { return (FogAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            if (ActiveTarget != null)
            {
                float baseValue;
                if (ActiveTarget.FogAnimTargets.Any(x => x != null && x.KeyFrames.Any() && !x.KeyFrames.IsConstantCurve(out baseValue)))
                {
                    CategoryView.SelectedNode = ctgCurveEdit;
                    return;
                }
            }
            CategoryView.SelectedNode = ctgGeneral;
        }

        protected override void Event_Document_PropertyChanged(object sender, IEnumerable<DocumentPropertyChangedArgs> e)
        {
            if (e.Any(x => x is SceneAnimationContentArg))
            {
                foreach (var target in Targets.GetObjects(GuiObjectID.FogAnimation).OfType<FogAnimation>().ToArray())
                {
                    if (!target.Owner.FogAnims.Contains(target))
                    {
                        Targets.Remove(target);
                    }
                }
                if (Targets.IsEmpty)
                {
                    Owner.Close();
                    return;
                }
            }
            base.Event_Document_PropertyChanged(sender, e);
        }
    }
}
