﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;

namespace App.PropertyEdit
{
    public partial class CurveView
    {
        public static readonly Color DefaultCurveColor = Color.FromArgb(153, 153, 255);
        private static readonly Color[] colorPreset_default = new[]
        {
            Color.FromArgb(230, 0, 0), Color.FromArgb(0, 230, 0), Color.FromArgb(74, 146, 255), Color.FromArgb(179, 191, 179)
        };
        private static readonly Color[] colorSample_ = new[]
        {
            Color.FromArgb(230,0,255),
            Color.FromArgb(30,180,255),
            Color.FromArgb(0,230,255),
            Color.FromArgb(150,230,50),
            Color.FromArgb(230,230,0),
            Color.FromArgb(230,150,50),
        };

        public static Color MakeColorFromString(string s)
        {
            //return DefaultCurveColor;
            return colorSample_[Math.Abs(s.GetHashCode() % colorSample_.Length)];
        }

        public static Color MakeRGBAColorFromIndex(int i)
        {
            return colorPreset_default[i % 4];
        }
    }
}
