﻿using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class BonePropertyPanel : ObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public BonePropertyPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return App.Utility.HelpUtility.PageKey.p_bone_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_Bone_Root, PropertyPageID.BoneRoot, BoneRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_Bone_General, PropertyPageID.BoneGeneral, BoneGeneralPage.CreateInstance,
                    updateModifiedFunc: () => BoneGeneralPage.IsModified(ActiveTarget));
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private Bone ActiveTarget
        {
            get { return (Bone)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgGeneral;
        }
    }
}
