﻿using App.Command;
using App.Data;

namespace App.PropertyEdit
{
    public partial class TextureRootPage : TexturePropertyPage
    {
        public TextureRootPage() :
            base(PropertyPageID.TextureRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_texture_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new TextureRootPage();
        }

        protected override void InitializeFormInternal()
        {
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
        }

        #region コピー＆ペースト
        private class CopyData
        {
 			public object TextureGeneralPage{ get; set; }
 			public object UserDataPage{ get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return TextureGeneralPage.CanCopy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(Texture target)
        {
            return
                new CopyData()
                {
                    TextureGeneralPage = TextureGeneralPage.Copy(target),
                    UserDataPage = UserDataPage.Copy(target)
                };
        }

        /// <summary>
        /// ペースト可能か
        /// </summary>
        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            return TextureGeneralPage.CanPaste(Targets, copiedObjectInfo, ((CopyData)copiedObject).TextureGeneralPage);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(TextureGeneralPage.Paste(targets, copyData.TextureGeneralPage));
                commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
            }

            commandSet.Reverse();
            return commandSet;
        }
        #endregion
    }
}
