﻿using System.Diagnostics;

using App.Command;
using App.ConfigData;
using App.Controls;
using App.Data;
using App.Utility;

using ConfigCommon;

using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class SkeletalAnimationGeneralPage : SkeletalAnimationPropertyPage
    {
        public SkeletalAnimationGeneralPage() :
            base(PropertyPageID.SkeletalAnimationGeneral)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window_general_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new SkeletalAnimationGeneralPage();
        }

        protected override void InitializeFormInternal()
        {
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            lblFrameCount.IsModified = ActiveTarget.IsValueChanged(x => x.frame_count);
            ltbFrameCount.Text		= ActiveTarget.Data.skeletal_anim_info.frame_count.ToString();

            lblFrameResolution.IsModified = ActiveTarget.IsValueChanged(x => x.frame_resolution);
            ltbFrameResolution.Text	= ActiveTarget.Data.skeletal_anim_info.frame_resolution.ToString();

            lblBakeAll.IsModified = ActiveTarget.IsValueChanged(x => x.bake_all);
            ltbBakeAll.Text			= UIText.FlagYesNo(ActiveTarget.Data.skeletal_anim_info.bake_all);

            cbxLoop.IsModified  = ActiveTarget.IsValueChanged(x => x.loop);
            cbxLoop.Checked     = ActiveTarget.Data.skeletal_anim_info.loop;

            lblDccPreset.IsModified = ActiveTarget.IsStringChanged(x => x.dcc_preset);
            ltbDccPreset.Text = ActiveTarget.Data.skeletal_anim_info.dcc_preset;

            lblDccMagnify.IsModified = ActiveTarget.IsValueChanged(x => x.dcc_magnify);
            ltbDccMagnify.Text = ActiveTarget.Data.skeletal_anim_info.dcc_magnify.ToString();

            lblDccStartFrame.IsModified = ActiveTarget.IsValueChanged(x => x.dcc_start_frame);
            ltbDccStartFrame.Text = ActiveTarget.Data.skeletal_anim_info.dcc_start_frame.ToString();

            lblEndFrame.IsModified = ActiveTarget.IsValueChanged(x => x.dcc_end_frame);
            ltbDccEndFrame.Text = ActiveTarget.Data.skeletal_anim_info.dcc_end_frame.ToString();

            lblDccFps.IsModified = ActiveTarget.IsValueChanged(x => x.dcc_fps);
            ltbDccFps.Text = ActiveTarget.Data.skeletal_anim_info.dcc_fps.ToString();

            lblScaleMode.IsModified = ActiveTarget.IsValueChanged(x => x.scale_mode);
            tbxScaleMode.Text		= UIText.EnumValue(ActiveTarget.Data.skeletal_anim_info.scale_mode);

            lblRotateMode.IsModified = ActiveTarget.IsValueChanged(x => x.rotate_mode);
            tbxRotateMode.Text		= UIText.EnumValue(ActiveTarget.Data.skeletal_anim_info.rotate_mode);

            lblBakeScale.IsModified = ActiveTarget.IsValueChanged(x => x.bake_tolerance_scale);
            ltbBakeScale.Text			= ActiveTarget.Data.skeletal_anim_info.bake_tolerance_scale.ToString();

            lblBakeRotate.IsModified = ActiveTarget.IsValueChanged(x => x.bake_tolerance_rotate);
            ltbBakeRotate.Text			= ActiveTarget.Data.skeletal_anim_info.bake_tolerance_rotate.ToString();

            lblBakeTranslate.IsModified = ActiveTarget.IsValueChanged(x => x.bake_tolerance_translate);
            ltbBakeTranslate.Text		= ActiveTarget.Data.skeletal_anim_info.bake_tolerance_translate.ToString();

            lblQuantizeScale.IsModified = ActiveTarget.IsValueChanged(x => x.quantize_tolerance_scale);
            fepQuantizeScale.Value      = ActiveTarget.Data.skeletal_anim_info.quantize_tolerance_scale;

            lblQuantizeRotate.IsModified = ActiveTarget.IsValueChanged(x => x.quantize_tolerance_rotate);
            fepQuantizeRotate.Value      = ActiveTarget.Data.skeletal_anim_info.quantize_tolerance_rotate;

            lblQuantizeTranslate.IsModified = ActiveTarget.IsValueChanged(x => x.quantize_tolerance_translate);
            fepQuantizeTranslate.Value      = ActiveTarget.Data.skeletal_anim_info.quantize_tolerance_translate;

            UpdateCompress(ActiveTarget);

            if (ApplicationConfig.DefaultValue.DisableAnimationQuantize)
            {
                lblLoopQuantizeInfoEdit.Visible = false;
                gbxQuantize.Visible = false;
                gbxQuantizationReductionRate.Visible = false;
            }
        }

        private void UpdateCompress(SkeletalAnimation target)
        {
            UpdateQuantizationResult(lstQuantizationResult,
                target.ScaleUncompressDataSize, target.ScaleCompressDataSize,
                target.RotateUncompressDataSize, target.RotateCompressDataSize,
                target.TranslateUncompressDataSize, target.TranslateCompressDataSize);
        }

        public static bool IsModified(SkeletalAnimation activeTarget)
        {
            return activeTarget != null &&
                (activeTarget.IsValueChanged(x => x.frame_count) ||
                activeTarget.IsValueChanged(x => x.frame_resolution) ||
                activeTarget.IsValueChanged(x => x.bake_all) ||
                activeTarget.IsValueChanged(x => x.loop) ||
                activeTarget.IsStringChanged(x => x.dcc_preset) ||
                activeTarget.IsValueChanged(x => x.dcc_magnify) ||
                activeTarget.IsValueChanged(x => x.dcc_start_frame) ||
                activeTarget.IsValueChanged(x => x.dcc_end_frame) ||
                activeTarget.IsValueChanged(x => x.dcc_fps) ||
                activeTarget.IsValueChanged(x => x.scale_mode) ||
                activeTarget.IsValueChanged(x => x.rotate_mode) ||
                activeTarget.IsValueChanged(x => x.bake_tolerance_scale) ||
                activeTarget.IsValueChanged(x => x.bake_tolerance_rotate) ||
                activeTarget.IsValueChanged(x => x.bake_tolerance_translate) ||
                activeTarget.IsValueChanged(x => x.quantize_tolerance_scale) ||
                activeTarget.IsValueChanged(x => x.quantize_tolerance_rotate) ||
                activeTarget.IsValueChanged(x => x.quantize_tolerance_translate));
        }
        #region コピー＆ペースト
        private class CopyData
        {
            public bool loop { get; set; }
            public float quantize_tolerance_scale { get; set; }
            public float quantize_tolerance_rotate { get; set; }
            public float quantize_tolerance_translate { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }


        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(SkeletalAnimation target)
        {
            return
                new CopyData()
                {
                    loop = target.Data.skeletal_anim_info.loop,
                    quantize_tolerance_scale = target.Data.skeletal_anim_info.quantize_tolerance_scale,
                    quantize_tolerance_rotate = target.Data.skeletal_anim_info.quantize_tolerance_rotate,
                    quantize_tolerance_translate = target.Data.skeletal_anim_info.quantize_tolerance_translate
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            EditCommandSet commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(SkeletalAnimationSettingPopup.CreateEditCommand_loop(targets, copyData.loop));
                commandSet.Add(
                    SkeletalAnimationSettingPopup.CreateEditCommand_quantize(
                        targets,
                        //
                        copyData.quantize_tolerance_scale,
                        copyData.quantize_tolerance_rotate,
                        copyData.quantize_tolerance_translate));
            }

            return commandSet.Execute();
        }
        #endregion
        #region イベント
        internal void fepQuantizeFrame_SequentialValueChanged(object sender, SequentialValueChangedEventArgs e)
        {
            if (e.Changing)
            {
                using (var currentTempFileName = TemporaryFileUtility.MakeDisposableFileName(".current" + G3dPath.SkeletalAnimBinaryExtension))
                {
                    (new DocumentSaver()).WriteDocument(ActiveTarget, currentTempFileName.Path, false);

                    Document tempDoc = null;
                    {
                        bool isSuccess = DocumentManager.Read(new DocumentManager.PathWithName(currentTempFileName.Path, string.Empty), out tempDoc);
                        Debug.Assert(isSuccess && (tempDoc is SkeletalAnimation));
                    }

                    // テンポラリに出力したドキュメントの実体
                    var target = (SkeletalAnimation)tempDoc;

                    // 最適化
                    target.Data.skeletal_anim_info.quantize_tolerance_scale = fepQuantizeScale.Value;
                    target.Data.skeletal_anim_info.quantize_tolerance_rotate = fepQuantizeRotate.Value;
                    target.Data.skeletal_anim_info.quantize_tolerance_translate = fepQuantizeTranslate.Value;
                    target.Optimize();

                    UpdateCompress(target);
                }
            }
            else
            {
                TheApp.CommandManager.Execute(
                    SkeletalAnimationSettingPopup.CreateEditCommand_quantize(
                        Targets,
                        //
                        fepQuantizeScale.Value,
                        fepQuantizeRotate.Value,
                        fepQuantizeTranslate.Value
                    )
                );
            }

        }

        private void fepQuantizeScale_SequentialValueChanged(object sender, SequentialValueChangedEventArgs e)
        {
            fepQuantizeFrame_SequentialValueChanged(sender, e);
        }

        private void fepQuantizeRotate_SequentialValueChanged(object sender, SequentialValueChangedEventArgs e)
        {
            fepQuantizeFrame_SequentialValueChanged(sender, e);
        }

        private void fepQuantizeTranslate_SequentialValueChanged(object sender, SequentialValueChangedEventArgs e)
        {
            fepQuantizeFrame_SequentialValueChanged(sender, e);
        }

        #endregion //イベント

        private void cbxLoop_CheckedChanged(object sender, System.EventArgs e)
        {
            TheApp.CommandManager.Execute(
                SkeletalAnimationSettingPopup.CreateEditCommand_loop(Targets, cbxLoop.Checked));
        }
    }
}
