﻿using System;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class ShapeMeshPage : ShapePropertyPage
    {
        public ShapeMeshPage() :
            base(PropertyPageID.ShapeMesh)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_shape_property_window_mesh_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ShapeMeshPage();
        }

        protected override void InitializeFormInternal()
        {
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            lblMesh.IsModified = ActiveTarget.IsSubmeshChanged();
            // メッシュ
            using (var ub = new UpdateBlock(lvwMesh))
            {
                lvwMesh.SetItemCount(ActiveTarget.Data.mesh_array.mesh.Length);
                int index = 0;
                foreach (var mesh in ActiveTarget.Data.mesh_array.mesh)
                {
                    ListViewItem item = lvwMesh.Items[index];
                    item.Tag = mesh;

                    // インデックス
                    item.SubItems[clhMeshIndex.Index].Text = index.ToString();

                    // プリミティブ
                    item.SubItems[clhPrimitive.Index].Text = UIText.EnumValue(mesh.mode);

                    // 頂点インデックスの型
                    item.SubItems[clhQuantizeType.Index].Text = UIText.EnumValue(mesh.quantize_type);

                    // 頂点インデックス数
                    item.SubItems[clhMeshIndexCount.Index].Text = mesh.count.ToString();

                    index++;
                }
            }

            if (lvwMesh.SelectedIndex == -1 && lvwMesh.Items.Count > 0)
            {
                lvwMesh.SetSelectedItem(0);
            }

            UpdateLvwSubmesh();
        }

        protected void UpdateLvwSubmesh()
        {

            using (var ub = new UpdateBlock(lvwSubmesh))
            {
                var selectedMesh = (meshType)lvwMesh.SelectedItemData;
                if (selectedMesh == null)
                {
                    lblSubmesh.IsModified = false;

                    lvwSubmesh.SetItemCount(0);
                }
                else
                {
                    lblSubmesh.IsModified = ActiveTarget.IsSubmeshChanged();

                    lvwSubmesh.SetItemCount(selectedMesh.submesh_array.submesh.Length);
                    int index = 0;
                    foreach (var submesh in selectedMesh.submesh_array.submesh)
                    {
                        ListViewItem item = lvwSubmesh.Items[index];
                        item.SubItems[clhIndex.Index].Text = index.ToString();
                        item.SubItems[clhOffset.Index].Text = submesh.offset.ToString();
                        item.SubItems[clhCount.Index].Text = submesh.count.ToString();
                        index++;
                    }
                }
            }
        }

        private void lvwMesh_SelectionChanged(object sender, EventArgs e)
        {
            UpdateLvwSubmesh();
        }

        public static bool IsModified(Shape activeTarget)
        {
            return activeTarget != null && activeTarget.IsSubmeshChanged();
        }
    }
}
