﻿using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Windows.Forms;
using System.Windows.Forms.VisualStyles;
using App.Data;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class ShapeBoundingPage : ShapePropertyPage
    {
        public ShapeBoundingPage() :
            base(PropertyPageID.ShapeMesh)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_shape_property_window_bounding_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ShapeBoundingPage();
        }

        protected override void InitializeFormInternal()
        {
        }

        public int[] Ranges;
        bool UpdateRanges()
        {
            var array = new int[uiListView1.Columns.Count];
            bool changed = false;
            for (int i = 0; i < array.Length; i++)
            {
                if (i == 0)
                {
                    array[i] = uiListView1.Columns[i].Width;
                }
                else
                {
                    array[i] = uiListView1.Columns[i].Width + array[i - 1];
                }
                changed |= array[i] != Ranges[i];
            }
            Ranges = array;
            return changed;
        }

        public class MultiTreeNode : TreeNode
        {
            public string[] Texts;
        }

        public class TreeListNode
        {
            public List<TreeListNode> Nodes = new List<TreeListNode>();
            public TreeListNode parent = null;
            public int VisibleCount { get { return visibleCount; } }
            private int visibleCount;
            public int Level;
            public bool IsExpanded
            {
                get
                {
                    return expand;
                }
                set
                {
                    if (expand != value)
                    {
                        expand = value;
                        UpdateVisibleCount();
                    }
                }
            }

            private void UpdateVisibleCount()
            {
                if (expand)
                {
                    visibleCount = Nodes.Sum(x => x.VisibleCount) + 1;
                }
                else
                {
                    visibleCount = 1;
                }

                if (parent != null)
                {
                    parent.UpdateVisibleCount();
                }
            }

            public bool expand = true;
            public void Initialize(int level, int index)
            {
                siblingIndex = index;
                Level = level;
                int i = 0;
                foreach (var child in Nodes)
                {
                    child.parent = this;
                    child.Initialize(level + 1, i);
                    i++;
                }

                IsExpanded = true;
                visibleCount = Nodes.Sum(x => x.VisibleCount) + 1;
            }
            private int siblingIndex;
            public int data;

            public TreeListNode VisibleItem(int index)
            {
                if (index == 0)
                {
                    return this;
                }

                index--;
                foreach (var child in Nodes)
                {
                    if (index < child.VisibleCount)
                    {
                        return child.VisibleItem(index);
                    }
                    index -= child.VisibleCount;
                }

                return null;
            }

            public TreeListNode PrevNode
            {
                get
                {
                    if (siblingIndex == 0)
                    {
                        return null;
                    }

                    return parent.Nodes[siblingIndex - 1];
                }
            }

            public TreeListNode NextNode
            {
                get
                {
                    if (parent == null || parent.Nodes.Count == siblingIndex + 1)
                    {
                        return null;
                    }

                    return parent.Nodes[siblingIndex + 1];
                }
            }
        }

        private void uiTreeView1_DrawNode(object sender, DrawTreeNodeEventArgs e)
        {
            var node = (MultiTreeNode)e.Node;
            Rectangle itemRect = e.Bounds;
            if (e.Bounds.Height < 1 || e.Bounds.Width < 1)
                return;

            using (var brush = new SolidBrush(uiTreeView1.BackColor))
            {
                e.Graphics.FillRectangle(brush, e.Bounds);
            }

            int cIndentBy = 19;
            int cMargin = 6;

            int indent = (node.Level * cIndentBy) + cMargin;
            int iconLeft = indent;
            int textLeft = iconLeft + 16;

            Color textColour = uiTreeView1.ForeColor;

            if (node.IsSelected)
            {
                if (uiTreeView1.Focused)
                {
                    e.Graphics.FillRectangle(SystemBrushes.Highlight, textLeft, itemRect.Top, itemRect.Right - textLeft, itemRect.Height - 1);
                    textColour = SystemColors.HighlightText;
                }
                else
                {
                    e.Graphics.FillRectangle(SystemBrushes.InactiveBorder, textLeft, itemRect.Top, itemRect.Right - textLeft, itemRect.Height - 1);
                }
            }

            itemRect.Width = Ranges[0];
            e.Graphics.SetClip(itemRect);
            Pen dotPen = new Pen(Color.FromArgb(128, 128, 128));
            dotPen.DashStyle = DashStyle.Dot;

            int midY = (itemRect.Top + itemRect.Bottom) / 2;

            // Draw parentage lines
            {
                int x = cMargin * 2;

                if (node.Level == 0 && node.PrevNode == null)
                {
                    // The very first node in the tree has a half-height line
                    //e.Graphics.DrawLine(dotPen, x, midY, x, itemRect.Bottom);
                }
                else
                {
                    // Used to only draw lines to nodes with Next Siblings, as in normal TreeViews
                    TreeNode testNode = node;
                    for (int iLine = node.Level; iLine >= 0; iLine--)
                    {
                        if (testNode.NextNode != null)
                        {
                            x = (iLine * cIndentBy) + (cMargin * 2);
                            e.Graphics.DrawLine(dotPen, x, itemRect.Top, x, itemRect.Bottom);
                        }

                        testNode = testNode.Parent;
                    }

                    x = (node.Level * cIndentBy) + cMargin * 2;
                    e.Graphics.DrawLine(dotPen, x, itemRect.Top, x, midY);
                }

                e.Graphics.DrawLine(dotPen, iconLeft + cMargin, midY, iconLeft + cMargin + 10, midY);
            }

            // Draw Expand (plus/minus) icon if required
            if (node.Nodes.Count > 0)
            {
                // Use the VisualStyles renderer to use the proper OS-defined glyphs
                Rectangle expandRect = new Rectangle(iconLeft - 1, midY - 7, 16, 16);

                VisualStyleElement element = node.IsExpanded ? VisualStyleElement.TreeView.Glyph.Opened : VisualStyleElement.TreeView.Glyph.Closed;

                VisualStyleRenderer renderer = new VisualStyleRenderer(element);
                renderer.DrawBackground(e.Graphics, expandRect);
            }

            // Draw the text, which is separated into columns by | characters
            Point textStartPos = new Point(itemRect.Left + textLeft, itemRect.Top);
            Point textPos = new Point(textStartPos.X, textStartPos.Y);

            Font textFont = TheApp.GuiFont;

            e.Graphics.ResetClip();
            Rectangle textRect = new Rectangle(textPos.X, textPos.Y, itemRect.Right - textPos.X, itemRect.Bottom - textPos.Y);
            using (var drawFormat = new StringFormat())
            {
                drawFormat.Alignment = StringAlignment.Near;
                drawFormat.LineAlignment = StringAlignment.Center;
                drawFormat.FormatFlags = StringFormatFlags.NoWrap;
                for (int i = 0; i < Ranges.Length; i++)
                {
                    if (i > 0)
                    {
                        drawFormat.Alignment = StringAlignment.Far;
                        textRect.X = Ranges[i - 1];
                        textRect.Width = Ranges[i] - Ranges[i - 1];
                    }
                    if (textRect.Width > 0)
                    {
                        e.Graphics.DrawString(node.Texts[i], textFont, new SolidBrush(textColour), textRect, drawFormat);
                    }
                }
            }
        }

        private void uiListView1_ColumnWidthChanging(object sender, ColumnWidthChangingEventArgs e)
        {
            if (UpdateRanges())
            {
                uiTreeView1.Invalidate();
            }
        }
    }
}
