﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using App.Controls;
using App.Utility;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit.ShaderParamControls
{
    public class ValueChangedEventArgs : EventArgs
    {
        // パラメーター名
        public string ParamName{ get; set; }

        // 変更後のパラメーター値
        public object ParamValue{ get; set; }
    }

    public class OptionValueChangedEventArgs : ValueChangedEventArgs
    {
        public OptionValueChangedEventArgs()
        {
            //Option = option;
        }

        // シーケンシャル変更イベント情報 -- シーケンシャル変更イベントでなければ null
        public SequentialValueChangedEventArgs SequentialValueChangedEventArgs { get; set; }


        // シーケンシャルで変更中 --> データの変更ではない
        public bool IsSequentialChanging
        {
            get
            {
                return (SequentialValueChangedEventArgs != null) && SequentialValueChangedEventArgs.Changing;
            }
        }
    }

    public class CombinerOptionValueChangedEventArgs : OptionValueChangedEventArgs
    {
    }

    public class SamplerValueChangedEventArgs : ValueChangedEventArgs
    {
    }

    public class AttributeValueChangedEventArgs : ValueChangedEventArgs
    {
    }

    public class RenderInfoValueChangedEventArgs : ValueChangedEventArgs
    {
        // 型
        public render_info_typeType type;

        // シーケンシャル変更イベント情報 -- シーケンシャル変更イベントでなければ null
        public SequentialValueChangedEventArgs SequentialValueChangedEventArgs { get; set; }

        // シーケンシャルで変更中 --> データの変更ではない
        public bool IsSequentialChanging
        {
            get
            {
                return (SequentialValueChangedEventArgs != null) && SequentialValueChangedEventArgs.Changing;
            }
        }
    }

    public class ShaderParamValueChangedEventArgs : ValueChangedEventArgs
    {
        public ShaderParamValueChangedEventArgs(shader_param_typeType shaderParamType)
        {
            ShaderParamType = shaderParamType;
        }

        // 要素インデックス
        public uint ElementBits{ get; set; }

        // シーケンシャル変更イベント情報 -- シーケンシャル変更イベントでなければ null
        public SequentialValueChangedEventArgs	SequentialValueChangedEventArgs{ get; set; }

        // シーケンシャルで変更中 --> データの変更ではない
        public bool IsSequentialChanging
        {
            get
            {
                return (SequentialValueChangedEventArgs != null) && SequentialValueChangedEventArgs.Changing;
            }
        }

        public bool[] BoolValueArray
        {
            get
            {
                if (ShaderTypeUtility.ParamPrimitiveTypeFromType(ShaderParamType) != ShaderTypeUtility.ParamPrimitiveTypeKind.@bool)
                {
                    return null;
                }
                else
                {
                    Debug.Assert((ParamValue is bool) || (ParamValue is bool[]));
                    return (ParamValue is bool) ? new[]{ (bool)ParamValue } : ParamValue as bool[];
                }
            }
        }

        public int[] IntValueArray
        {
            get
            {
                if (ShaderTypeUtility.ParamPrimitiveTypeFromType(ShaderParamType) != ShaderTypeUtility.ParamPrimitiveTypeKind.@int)
                {
                    return null;
                }
                else
                {
                    Debug.Assert((ParamValue is int) || (ParamValue is int[]));
                    return (ParamValue is int) ? new[]{ (int)ParamValue } : ParamValue as int[];
                }
            }
        }

        public uint[] UintValueArray
        {
            get
            {
                if (ShaderTypeUtility.ParamPrimitiveTypeFromType(ShaderParamType) != ShaderTypeUtility.ParamPrimitiveTypeKind.@uint)
                {
                    return null;
                }
                else
                {
                    Debug.Assert((ParamValue is uint) || (ParamValue is uint[]));
                    return (ParamValue is uint) ? new[]{ (uint)ParamValue } : ParamValue as uint[];
                }
            }
        }

        public float[] FloatValueArray
        {
            get
            {
                if (ShaderTypeUtility.ParamPrimitiveTypeFromType(ShaderParamType) != ShaderTypeUtility.ParamPrimitiveTypeKind.@float)
                {
                    return null;
                }
                else
                {
                    Debug.Assert((ParamValue is float) || (ParamValue is float[]));
                    return (ParamValue is float) ? new[]{ (float)ParamValue } : ParamValue as float[];
                }
            }
        }

        // パラメーターの型
        public shader_param_typeType ShaderParamType{ get; private set; }

        public ShaderTypeUtility.ParamPrimitiveTypeKind ParamElemType {
            get { return ShaderTypeUtility.ParamPrimitiveTypeFromType(ShaderParamType); }
        }
    }

    public delegate void ValueChangedEventHandler(object sender, ValueChangedEventArgs e);

    public enum ParamType
    {
        option_var,
        attrib_var,
        sampler_var,
        uniform_var,
        render_info_slot,
        group,
        page,
    }

    public class LabelChangedEventArgs
    {
        // パラメーター名
        public string ParamName { get; set; }

        // 変更後のパラメーター値
        public string Lebel { get; set; }

        public ParamType ParamType { get; set; }
    }

    public delegate void LabelChangedEventHandler(object sender, LabelChangedEventArgs e);

    public class ColorControlChangedEventArgs
    {
        // パラメーター名
        public string ParamName { get; set; }

        // 変更後のカラー表示状態
        public bool ShowColor { get; set; }
    }

    public delegate void ColorControlChangedEventHandler(object sender, ColorControlChangedEventArgs e);

    public class LinkClickedEventArgs : EventArgs
    {
        public string Target { get; set; }
        public string Group { get; set; }
        public ParamType ParamType { get; set; }
    }

    public delegate void LinkClickedEventHandler(object sender, LinkClickedEventArgs e);
}
