﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using App.Command;
using App.Data;
using System;
using System.Linq;
using App.ConfigData;

namespace App.PropertyEdit
{
    public partial class MaterialRootPage : MaterialPropertyPage
    {
        public MaterialRootPage()
            : base(PropertyPageID.MaterialRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_material_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new MaterialRootPage();
        }

        protected override void InitializeFormInternal()
        {
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
        }

        #region コピー＆ペースト
        private class CopyData
        {
 			public object MaterialGeneralPage{ get; set; }
 			public object MaterialRenderStatePage{ get; set; }
 			public object MaterialSamplerPage{ get; set; }
 			public object MaterialShaderPage{ get; set; }
            //public object MaterialOriginalInfoPage { get; set; }		編集される情報がないので使用しない
            public object UserDataPage { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return MaterialShaderPage.CanCopy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(Material target)
        {
            var materialSamplerPage = MaterialSamplerPage.Copy(target);
            var materialShaderPage = MaterialShaderPage.Copy(target);
            if (ApplicationConfig.Preset.FollowDccSamplerNameRule)
            {
                foreach (var item in ((MaterialShaderPage.CopyData)materialShaderPage).itemsCopyData.SamplerAssigns)
                {
                    string converted;
                    if (((MaterialSamplerPage.CopyData)materialSamplerPage).convertResult.TryGetValue(item.Item2.sampler_name, out converted))
                    {
                        item.Item2.sampler_name = converted;
                    }
                }
            }
            return
                new CopyData()
                {
                    MaterialGeneralPage = MaterialGeneralPage.Copy(target),
                    MaterialRenderStatePage = MaterialRenderStatePage.Copy(target),
                    MaterialSamplerPage = materialSamplerPage,
                    MaterialShaderPage = materialShaderPage,
                    UserDataPage = UserDataPage.Copy(target)
                };
        }

        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            if (!base.CanPaste(copiedObjectInfo, copiedObject))
            {
                return false;
            }

            var data = (CopyData)copiedObject;
            return MaterialSamplerPage.CanPaste(Targets, data.MaterialSamplerPage) && MaterialShaderPage.CanPaste(data.MaterialShaderPage);

        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(MaterialGeneralPage.Paste(targets, copyData.MaterialGeneralPage));
                commandSet.Add(MaterialRenderStatePage.Paste(targets, copyData.MaterialRenderStatePage, false));
                commandSet.Add(MaterialSamplerPage.Paste(targets, copyData.MaterialSamplerPage, false));
                commandSet.Add(MaterialShaderPage.Paste(targets, copyData.MaterialShaderPage, false));
                commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
            }
            var materials = targets.Objects.OfType<Material>().ToArray();
            EventHandler postEdit = (s, e) =>
                {
                    foreach (var model in materials.SelectMany(x => x.Referrers).Distinct())
                    {
                        Viewer.LoadOrReloadModel.Send(model);
                    }
                };

            commandSet.Reverse();
            postEdit(null, null);
            commandSet.OnPostEdit += postEdit;
            return commandSet;
        }
        #endregion
    }
}
