﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using App.Command;
using App.Data;

namespace App.PropertyEdit
{
    public partial class CameraAnimationRootPage : CameraAnimationPropertyPage
    {
        public CameraAnimationRootPage() :
            base(PropertyPageID.CameraAnimationRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new CameraAnimationRootPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            ;
        }

        #region コピー＆ペースト
        private class CopyData
        {
            public object CameraAnimationGeneralPage{ get; set; }
            public object CameraAnimationCurveEditPage{ get; set; }
            public object UserDataPage { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(CameraAnimation target)
        {
            return
                new CopyData()
                {
                    CameraAnimationGeneralPage = CameraAnimationGeneralPage.Copy(target),
                    CameraAnimationCurveEditPage = CameraAnimationCurveEditPage.Copy(target),
                    UserDataPage = UserDataPage.Copy(target),
                };
        }

        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            return CanPaste(ActiveTarget, copiedObjectInfo, copiedObject);
        }

        public static bool CanPaste(CameraAnimation activeTarget, object copiedObjectInfo, object copiedObject)
        {
            var copyData = (CopyData)copiedObject;
            return CameraAnimationGeneralPage.CanPaste(activeTarget, copiedObjectInfo, copyData.CameraAnimationGeneralPage) &&
                CameraAnimationCurveEditPage.CanPaste(activeTarget, copiedObjectInfo, copyData.CameraAnimationCurveEditPage);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            commandSet.SetViewerDrawSuppressBlockDelegate(AnimationCurveEditCommand.AnimationMessageFilter);
            using (var block = new Viewer.ViewerDrawSuppressBlock(AnimationCurveEditCommand.AnimationMessageFilter))
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(CameraAnimationGeneralPage.Paste(targets, copyData.CameraAnimationGeneralPage));
                commandSet.Add(CameraAnimationCurveEditPage.Paste(targets, copyData.CameraAnimationCurveEditPage));
                commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
            }

            commandSet.Reverse();
            return commandSet;
        }
        #endregion
    }
}
