﻿using App.Command;
using App.Data;

namespace App.PropertyEdit
{
    public partial class BoneVisibilityAnimationRootPage : BoneVisibilityAnimationPropertyPage
    {
        public BoneVisibilityAnimationRootPage() :
            base(PropertyPageID.BoneVisibilityAnimationRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new BoneVisibilityAnimationRootPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            ;
        }

        #region コピー＆ペースト
        private class CopyData
        {
            public object BoneVisibilityAnimationGeneralPage{ get; set; }
            public object BoneVisibilityAnimationCurveEditPage{ get; set; }
 			public object UserDataPage{ get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(BoneVisibilityAnimation target)
        {
            return
                new CopyData()
                {
                    BoneVisibilityAnimationGeneralPage = BoneVisibilityAnimationGeneralPage.Copy(target),
                    BoneVisibilityAnimationCurveEditPage = BoneVisibilityAnimationCurveEditPage.Copy(target),
                    UserDataPage = UserDataPage.Copy(target)
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(BoneVisibilityAnimationGeneralPage.Paste(targets, copyData.BoneVisibilityAnimationGeneralPage));
                commandSet.Add(BoneVisibilityAnimationCurveEditPage.Paste(targets, copyData.BoneVisibilityAnimationCurveEditPage));
                commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
            }

            commandSet.Reverse();
            return commandSet;
        }
        #endregion
    }
}
