﻿using System;
using App.Command;
using App.Data;
using ConfigCommon;

namespace App.PropertyEdit
{
    public partial class BoneVisibilityAnimationGeneralPage : BoneVisibilityAnimationPropertyPage
    {
        public BoneVisibilityAnimationGeneralPage() :
            base(PropertyPageID.BoneVisibilityAnimationGeneral)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window_general_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new BoneVisibilityAnimationGeneralPage();
        }

        protected override void InitializeFormInternal()
        {
            iepFrameSize.SequentialValueChanged +=
                (s, e) =>
                {
                    if (!e.Changing)
                    {
                        TheApp.CommandManager.Execute(CreateEditCommand_frame_count(Targets, iepFrameSize.Value));
                    }
                };
            cbxLoop.CheckedChanged +=
                (s, e) => TheApp.CommandManager.Execute(CreateEditCommand_loop(Targets, cbxLoop.Checked));
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            BoneVisibilityAnimation target = ActiveTarget;
            var info = target.Data.bone_visibility_anim_info;
            lblFrameSize.IsModified = target.IsValueChanged(x => x.frame_count);
            iepFrameSize.Value = info.frame_count;

            cbxLoop.IsModified = target.IsValueChanged(x => x.loop);
            cbxLoop.Checked = info.loop;

            lblFrameResolution.IsModified = target.IsValueChanged(x => x.frame_resolution);
            ltbFrameResolution.Text	= target.Data.bone_visibility_anim_info.frame_resolution.ToString();

            lblBakeAll.IsModified = target.IsValueChanged(x => x.bake_all);
            ltbBakeAll.Text			= UIText.FlagYesNo(target.Data.bone_visibility_anim_info.bake_all);

            lblDccPreset.IsModified = target.IsStringChanged(x => x.dcc_preset);
            ltbDccPreset.Text = target.Data.bone_visibility_anim_info.dcc_preset;

            lblDccStartFrame.IsModified = target.IsValueChanged(x => x.dcc_start_frame);
            ltbDccStartFrame.Text = target.Data.bone_visibility_anim_info.dcc_start_frame.ToString();

            lblDccEndFrame.IsModified = target.IsValueChanged(x => x.dcc_end_frame);
            ltbDccEndFrame.Text = target.Data.bone_visibility_anim_info.dcc_end_frame.ToString();

            lblDccFps.IsModified = target.IsValueChanged(x => x.dcc_fps);
            ltbDccFps.Text = target.Data.bone_visibility_anim_info.dcc_fps.ToString();
        }

        public static bool IsModified(BoneVisibilityAnimation target)
        {
            return target != null &&
                (target.IsValueChanged(x => x.frame_count) ||
                target.IsValueChanged(x => x.frame_resolution) ||
                target.IsValueChanged(x => x.bake_all) ||
                target.IsValueChanged(x => x.loop) ||
                target.IsStringChanged(x => x.dcc_preset) ||
                target.IsValueChanged(x => x.dcc_start_frame) ||
                target.IsValueChanged(x => x.dcc_end_frame) ||
                target.IsValueChanged(x => x.dcc_fps));
        }

        #region コマンド
        public static GroupEditCommand CreateEditCommand_frame_count(GuiObjectGroup targets, int FrameCount)
        {
            return
                new GeneralGroupValueEditCommand<int>(
                    targets,
                    GuiObjectID.BoneVisibilityAnimation,
                    FrameCount,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        var anim = target as BoneVisibilityAnimation;

                        swap = anim.Data.bone_visibility_anim_info.frame_count;
                        anim.Data.bone_visibility_anim_info.frame_count = (int)data;
                        AnimationDocument.NotifyFrameCountChanged(anim, EventArgs.Empty);

                        // Viewerへ再転送
                        Viewer.LoadOrReloadAnimation.Send(anim);
                    },
                    postEditDelegate : (editTargets, data) =>
                    {
                        ;	// リロードはまとめて送れないのでEditDelegateで送る
                    }
                );
        }

        public static GroupEditCommand CreateEditCommand_loop(GuiObjectGroup targets, bool loop)
        {
            return
                new GeneralGroupValueEditCommand<bool>(
                    targets,
                    GuiObjectID.BoneVisibilityAnimation,
                    loop,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        var anim = target as BoneVisibilityAnimation;

                        swap = anim.Data.bone_visibility_anim_info.loop;
                        anim.Data.bone_visibility_anim_info.loop = (bool)data;

                        // Viewerへ再転送
                        Viewer.LoadOrReloadAnimation.Send(anim);
                    },
                    postEditDelegate : (editTargets, data) =>
                    {
                        ;	// リロードはまとめて送れないのでEditDelegateで送る
                    }
                );
        }
        #endregion

        #region コピー＆ペースト
        private class CopyData
        {
            public int													frame_count { get; set; }
            public bool													loop { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(BoneVisibilityAnimation target)
        {
            return
                new CopyData()
                {
                    frame_count					= target.Data.bone_visibility_anim_info.frame_count,
                    loop						= target.Data.bone_visibility_anim_info.loop,
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            EditCommandSet commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(CreateEditCommand_frame_count(targets, copyData.frame_count));
                commandSet.Add(CreateEditCommand_loop(targets, copyData.loop));
            }

            return commandSet.Execute();
        }
        #endregion
    }
}
