﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.Utility;

namespace App.ObjectView.List
{
    /// <summary>
    /// モデルリストビュークラス。
    /// </summary>
    [ToolboxItem(false)]
    public sealed class VertexListView : StandardObjectListView
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public VertexListView()
            : base(ViewID.Vertex, AppConfig.ObjectViewMode.VertexList)
        {
        }

        /// <summary>
        /// 列項目初期化。
        /// </summary>
        public static void InitializeColumn()
        {
            BeginRegisterColumn(ViewID.Vertex, "VertexListView");
            {
                RegisterColumn(ColumnID.Name,           "Name",           "LISTVIEW_MODEL_COLUMN_NAME",            HorizontalAlignment.Left,  _columnDefaultWidthL);
            }
            EndRegisterColumn(typeof(ColumnID));
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void CreateItem()
        {
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnCustomDrawItem(CustomDrawListViewItemEventArgs e)
        {
            Vertex o = (Vertex)e.Item.Tag;

            switch ((ColumnID)e.ColumnHeader.Tag)
            {
                case ColumnID.Name:
                    e.SpecificText = o.Name;
                    break;
                default:
                    DrawItem_Invalid(e);
                    break;
            }

            base.OnCustomDrawItem(e);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override int OnCompareItem(CompareListViewItemEventArgs e)
        {
            Vertex o1 = (Vertex)e.Item1.Tag;
            Vertex o2 = (Vertex)e.Item2.Tag;

            switch ((ColumnID)e.ColumnHeader.Tag)
            {
                case ColumnID.Name:
                    return e.CompareString(o1.Name, o2.Name);
                default:
                    Debug.Assert(false);
                    break;
            }

            return 0;
        }

        #region ColumnID
        /// <summary>
        /// 列項目ＩＤ。
        /// </summary>
        public enum ColumnID
        {
            /// <summary>名前。</summary>
            Name,
        }
        #endregion
    }
}
