﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml.Serialization;

namespace App.Data
{
    /// <summary>
    /// 4次元ベクトル
    /// </summary>
    [Serializable]
    public struct Vector4
    {
        public Vector4(float x, float y, float z, float w = 1.0f) : this()
        {
            Set(x, y, z, w);
        }

        public Vector4(Vector4 vec) : this()
        {

            Set(vec.X, vec.Y, vec.Z, vec.W);
        }

        public override string ToString()
        {
            return string.Format("({0}, {1}, {2}, {3})", X, Y, Z, W);
        }

        public float[] ToArray()
        {
            return new[] { X, Y, Z, W };
        }

        /// <summary>
        /// 設定
        /// </summary>
        public void Set(float x, float y, float z, float w = 1.0f)
        {
            X = x;
            Y = y;
            Z = z;
            W = w;
        }

        /// <summary>
        /// 設定
        /// </summary>
        public void Set(Vector4 vec)
        {
            Set(vec.X, vec.Y, vec.Z, vec.W);
        }

        /// <summary>
        /// X 成分を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public float X { get; set; }

        /// <summary>
        /// Y 成分を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public float Y { get; set; }

        /// <summary>
        /// Z 成分を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public float Z { get; set; }

        /// <summary>
        /// W 成分を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public float W { get; set; }

        /// <summary>
        /// SelectElement。
        /// </summary>
        public static Vector4 SelectElement(Vector4 src, Vector4 dst, uint dstElemBits)
        {
            if((dstElemBits & (1<<0)) != 0){	src.X = dst.X;	}
            if((dstElemBits & (1<<1)) != 0){	src.Y = dst.Y;	}
            if((dstElemBits & (1<<2)) != 0){	src.Z = dst.Z;	}
            if((dstElemBits & (1<<3)) != 0){	src.W = dst.W;	}

            return src;
        }

        /// <summary>
        /// 比較
        /// </summary>
        public static bool operator ==(Vector4 lhs, Vector4 rhs)
        {
            return lhs.X == rhs.X && lhs.Y == rhs.Y && lhs.Z == rhs.Z && lhs.W == rhs.W;
        }

        /// <summary>
        /// 比較
        /// </summary>
        public static bool operator !=(Vector4 lhs, Vector4 rhs)
        {
            return !(lhs == rhs);
        }

        /// <summary>
        /// ハッシュコード
        /// </summary>
        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        /// <summary>
        /// 比較
        /// </summary>
        public override bool Equals(object obj)
        {
            return base.Equals(obj);
        }
    }
}
