﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using nw.g3d.iflib;

namespace App.Data
{
    public class SceneAnimationMerger
    {
        public SceneAnimation MergeFile(SceneAnimation dstAnim, string srcAnimPath, MergerUtility.MergeMode mergeMode)
        {
            using (var block = new App.AppContext.PropertyChangedSuppressBlock())
            using (var vdsb = new Viewer.ViewerDrawSuppressBlock())
            {
                // マージ元アニメーションを読み込む
                var srcAnim = MergerUtility.LoadDocument<SceneAnimation>(srcAnimPath);

                // 対象のクローンを作る
                var clonedDstAnim = MergerUtility.CloneDocument(dstAnim);

                // マージする
                {
                    Debug.Assert(clonedDstAnim is SceneAnimation);
                    Debug.Assert(srcAnim is SceneAnimation);

                    var dstStreams = clonedDstAnim.BinaryStreams;
                    var srcStreams = srcAnim.BinaryStreams;

                    var context = new IfSceneAnimMergeContext(
                        (clonedDstAnim as SceneAnimation).Data, dstStreams,
                        (srcAnim       as SceneAnimation).Data, srcStreams
                    );

                    context.Setup();

                    IfSceneAnimMerger.Merge(
                        context
                    );

                    // 最適化ログの追加
                    MergerUtility.AddOptimizeLog(clonedDstAnim, clonedDstAnim.Data, srcAnimPath);
                }

                clonedDstAnim.Initialize();

                return clonedDstAnim;
            }
        }
    }
}
