﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.Windows.Forms;
using App.Controls;
using nw.g3d.iflib;

namespace App.Data
{
    public class MaterialVisibilityAnimationMerger
    {
        public MaterialVisibilityAnimation MergeFile(MaterialVisibilityAnimation dstAnim, string srcAnimPath, MergerUtility.MergeMode mergeMode)
        {
            mergeMode = MergerUtility.MergeMode.Auto;

            using (var block = new App.AppContext.PropertyChangedSuppressBlock())
            using (var vdsb = new Viewer.ViewerDrawSuppressBlock())
            {
                // マージ元アニメーションを読み込む
                var srcAnim = MergerUtility.LoadDocument<MaterialVisibilityAnimation>(srcAnimPath);

                // マージダイアログを開いて変換情報を作る
                IfMatVisibilityAnimMerger.IfMatVisibilityAnimMergerInfo info = null;

                if(mergeMode != MergerUtility.MergeMode.Auto)
                {
                    using(var dialog = new MaterialVisibilityAnimationMergeDialog(dstAnim, srcAnim))
                    {
                        if ((mergeMode == MergerUtility.MergeMode.Manual) || (dialog.IsSame == false))
                        {
                            if (dialog.ShowDialog() != DialogResult.OK)
                            {
                                return null;
                            }
                        }

                        info = new IfMatVisibilityAnimMerger.IfMatVisibilityAnimMergerInfo()
                        {
                            MaterialNamePairTable	= dialog.MaterialNamePairTable,
                        };
                    }
                }

                // 対象のクローンを作る
                var clonedDstAnim = MergerUtility.CloneDocument(dstAnim);

                // マージする
                {
                    Debug.Assert(clonedDstAnim is MaterialVisibilityAnimation);
                    Debug.Assert(srcAnim is MaterialVisibilityAnimation);

                    var dstStreams = clonedDstAnim.BinaryStreams;
                    var srcStreams = srcAnim.BinaryStreams;

                    if (info != null)
                    {
                        IfMatVisibilityAnimMerger.Merge(
                            (clonedDstAnim as MaterialVisibilityAnimation).Data, dstStreams,
                            (srcAnim       as MaterialVisibilityAnimation).Data, srcStreams,
                            info
                        );
                    }
                    else
                    {
                        IfMatVisibilityAnimMerger.Merge(
                            (clonedDstAnim as MaterialVisibilityAnimation).Data, dstStreams,
                            (srcAnim       as MaterialVisibilityAnimation).Data, srcStreams
                        );
                    }

                    // 最適化ログの追加
                    MergerUtility.AddOptimizeLog(clonedDstAnim, clonedDstAnim.Data, srcAnimPath);
                }

                clonedDstAnim.Initialize();

                return clonedDstAnim;
            }
        }
    }
}
